/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbimport;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.cayenne.dbimport.Catalog;
import org.apache.cayenne.dbimport.FilterContainer;
import org.apache.cayenne.dbimport.Schema;
import org.apache.cayenne.resource.Resource;

@XmlRootElement(name="reverseEngineering")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ReverseEngineering
extends FilterContainer
implements Serializable {
    @XmlTransient
    protected Resource configurationSource;
    @XmlTransient
    private String name;
    private Boolean skipRelationshipsLoading;
    private Boolean skipPrimaryKeyLoading;
    @XmlElement(name="tableType")
    private Collection<String> tableTypes = new LinkedList<String>();
    @XmlElement(name="catalog")
    private Collection<Catalog> catalogs = new LinkedList<Catalog>();
    @XmlElement(name="schema")
    private Collection<Schema> schemas = new LinkedList<Schema>();

    public ReverseEngineering(String name) {
        this.name = name;
    }

    public ReverseEngineering() {
    }

    public Boolean getSkipRelationshipsLoading() {
        return this.skipRelationshipsLoading;
    }

    public void setSkipRelationshipsLoading(Boolean skipRelationshipsLoading) {
        this.skipRelationshipsLoading = skipRelationshipsLoading;
    }

    public Boolean getSkipPrimaryKeyLoading() {
        return this.skipPrimaryKeyLoading;
    }

    public void setSkipPrimaryKeyLoading(Boolean skipPrimaryKeyLoading) {
        this.skipPrimaryKeyLoading = skipPrimaryKeyLoading;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<Catalog> getCatalogs() {
        return this.catalogs;
    }

    public void setCatalogs(Collection<Catalog> catalogs) {
        this.catalogs = catalogs;
    }

    public Collection<Schema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Collection<Schema> schemas) {
        this.schemas = schemas;
    }

    public String[] getTableTypes() {
        return this.tableTypes.toArray(new String[this.tableTypes.size()]);
    }

    public void setTableTypes(Collection<String> tableTypes) {
        this.tableTypes = tableTypes;
    }

    public void addTableType(String type) {
        this.tableTypes.add(type);
    }

    public void addSchema(Schema schema) {
        this.schemas.add(schema);
    }

    public void addCatalog(Catalog catalog) {
        this.catalogs.add(catalog);
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("ReverseEngineering: ").append("\n");
        if (!ReverseEngineering.isBlank(this.catalogs)) {
            for (Catalog catalog : this.catalogs) {
                catalog.toString(res, "  ");
            }
        }
        if (!ReverseEngineering.isBlank(this.schemas)) {
            for (Schema schema : this.schemas) {
                schema.toString(res, "  ");
            }
        }
        if (this.skipRelationshipsLoading != null && this.skipRelationshipsLoading.booleanValue()) {
            res.append("\n").append("        Skip Relationships Loading");
        }
        if (this.skipPrimaryKeyLoading != null && this.skipPrimaryKeyLoading.booleanValue()) {
            res.append("\n").append("        Skip PrimaryKey Loading");
        }
        return super.toString(res, "  ").toString();
    }

    public Resource getConfigurationSource() {
        return this.configurationSource;
    }

    public void setConfigurationSource(Resource configurationSource) {
        this.configurationSource = configurationSource;
    }
}

