/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbimport;

import java.util.Collection;
import java.util.LinkedList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.cayenne.dbimport.AntNestedElement;
import org.apache.cayenne.dbimport.FilterContainer;
import org.apache.cayenne.dbimport.Schema;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Catalog
extends FilterContainer {
    @XmlAttribute(name="name")
    private String name;
    @XmlElement(name="schema")
    private Collection<Schema> schemas = new LinkedList<Schema>();

    public Catalog() {
    }

    public Catalog(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<Schema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Collection<Schema> schemas) {
        this.schemas = schemas;
    }

    public void addSchema(Schema schema) {
        this.schemas.add(schema);
    }

    public void set(String name) {
        this.setName(name);
    }

    public void addConfiguredName(AntNestedElement name) {
        this.setName(name.getName());
    }

    public void addText(String name) {
        if (name.trim().isEmpty()) {
            return;
        }
        this.setName(name);
    }

    public Catalog schema(Schema name) {
        this.addSchema(name);
        return this;
    }

    @Override
    public boolean isEmptyContainer() {
        if (!super.isEmptyContainer()) {
            return false;
        }
        if (this.schemas.isEmpty()) {
            return true;
        }
        for (Schema schema : this.schemas) {
            if (schema.isEmptyContainer()) continue;
            return false;
        }
        return true;
    }

    @Override
    public StringBuilder toString(StringBuilder res, String prefix) {
        res.append(prefix).append("Catalog: ").append(this.name).append("\n");
        if (!Catalog.isBlank(this.schemas)) {
            for (Schema schema : this.schemas) {
                schema.toString(res, prefix + "  ");
            }
        }
        return super.toString(res, prefix + "  ");
    }
}

