/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.util;

import java.util.Map;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.query.SQLTemplate;

public class SQLTemplateCustomizer {
    protected DbAdapter adapter;
    protected Map<String, Map<String, String>> sqlMap;

    public SQLTemplateCustomizer(Map<String, Map<String, String>> sqlMap, DbAdapter adapter) {
        this.sqlMap = sqlMap;
        this.adapter = adapter;
    }

    public void updateSQLTemplate(SQLTemplate query) {
        String key;
        String template;
        Map<String, String> customSQL = this.sqlMap.get(query.getDefaultTemplate());
        if (customSQL != null && (template = customSQL.get(key = this.adapter.getClass().getName())) != null) {
            query.setTemplate(key, template);
        }
    }

    public SQLTemplate createSQLTemplate(Class<?> root, String defaultTemplate) {
        SQLTemplate template = new SQLTemplate(root, defaultTemplate);
        this.updateSQLTemplate(template);
        return template;
    }
}

