/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.junit.Assert;
import org.junit.Test;

public class SelectQueryDescriptorTest {
    @Test
    public void testGetQueryType() throws Exception {
        SelectQueryDescriptor builder = QueryDescriptor.selectQueryDescriptor();
        builder.setRoot("FakeRoot");
        Assert.assertTrue((boolean)(builder.buildQuery() instanceof SelectQuery));
    }

    @Test
    public void testGetQueryName() throws Exception {
        SelectQueryDescriptor builder = QueryDescriptor.selectQueryDescriptor();
        builder.setRoot("FakeRoot");
        builder.setName("xyz");
        Assert.assertEquals((Object)"xyz", (Object)((AbstractQuery)builder.buildQuery()).getName());
    }

    @Test
    public void testGetQueryRoot() throws Exception {
        DataMap map = new DataMap();
        ObjEntity entity = new ObjEntity("A");
        map.addObjEntity(entity);
        SelectQueryDescriptor builder = QueryDescriptor.selectQueryDescriptor();
        builder.setRoot(entity);
        Assert.assertTrue((boolean)(builder.buildQuery() instanceof SelectQuery));
        Assert.assertSame((Object)entity, (Object)((AbstractQuery)builder.buildQuery()).getRoot());
    }

    @Test
    public void testGetQueryQualifier() throws Exception {
        SelectQueryDescriptor builder = QueryDescriptor.selectQueryDescriptor();
        builder.setRoot("FakeRoot");
        builder.setQualifier(Expression.fromString("abc = 5"));
        Query query = builder.buildQuery();
        Assert.assertEquals((Object)Expression.fromString("abc = 5"), (Object)((SelectQuery)query).getQualifier());
    }

    @Test
    public void testGetQueryProperties() throws Exception {
        SelectQueryDescriptor builder = QueryDescriptor.selectQueryDescriptor();
        builder.setRoot("FakeRoot");
        builder.setProperty("cayenne.GenericSelectQuery.fetchLimit", "5");
        builder.setProperty("cayenne.GenericSelectQuery.statementFetchSize", "6");
        Query query = builder.buildQuery();
        Assert.assertTrue((boolean)(query instanceof SelectQuery));
        Assert.assertEquals((long)5L, (long)((SelectQuery)query).getFetchLimit());
        Assert.assertEquals((long)6L, (long)((SelectQuery)query).getStatementFetchSize());
    }
}

