/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.Collections;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.junit.Assert;
import org.junit.Test;

public class EntityInheritanceTreeTest {
    @Test
    public void testEntityMatchingRow_NoInheritance() {
        DataMap dataMap = new DataMap("map");
        DbEntity dbEntity = new DbEntity("e1");
        dbEntity.addAttribute(new DbAttribute("x"));
        dataMap.addDbEntity(dbEntity);
        ObjEntity entity = new ObjEntity("E1");
        entity.setDbEntityName(dbEntity.getName());
        dataMap.addObjEntity(entity);
        EntityInheritanceTree t1 = new EntityInheritanceTree(entity);
        DataRow row11 = new DataRow(5);
        row11.put("x", 1);
        Assert.assertSame((Object)entity, (Object)t1.entityMatchingRow(row11));
        entity.setDeclaredQualifier(ExpressionFactory.matchDbExp("x", 2));
        Assert.assertNull((Object)t1.entityMatchingRow(row11));
        DataRow row12 = new DataRow(5);
        row12.put("x", 2);
        Assert.assertSame((Object)entity, (Object)t1.entityMatchingRow(row12));
    }

    @Test
    public void testEntityMatchingRow_SingleTableInheritance() {
        DataMap dataMap = new DataMap("map");
        DbEntity dbEntity = new DbEntity("e1");
        dbEntity.addAttribute(new DbAttribute("x"));
        dataMap.addDbEntity(dbEntity);
        ObjEntity entity = new ObjEntity("E1");
        entity.setDbEntityName(dbEntity.getName());
        entity.setDeclaredQualifier(ExpressionFactory.matchDbExp("x", 2));
        dataMap.addObjEntity(entity);
        ObjEntity subEntity = new ObjEntity("E2");
        subEntity.setSuperEntityName("E1");
        subEntity.setDeclaredQualifier(ExpressionFactory.matchDbExp("x", 1));
        dataMap.addObjEntity(subEntity);
        EntityResolver resolver = new EntityResolver(Collections.singleton(dataMap));
        EntityInheritanceTree t1 = resolver.getInheritanceTree("E1");
        DataRow row11 = new DataRow(5);
        row11.put("x", 1);
        DataRow row12 = new DataRow(5);
        row12.put("x", 2);
        DataRow row13 = new DataRow(5);
        row13.put("x", 3);
        Assert.assertSame((Object)subEntity, (Object)t1.entityMatchingRow(row11));
        Assert.assertSame((Object)entity, (Object)t1.entityMatchingRow(row12));
        Assert.assertNull((Object)t1.entityMatchingRow(row13));
    }
}

