/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.junit.Assert;
import org.junit.Test;

public class EmbeddableTest {
    @Test
    public void testClassName() {
        Embeddable e1 = new Embeddable();
        Assert.assertNull((Object)e1.getClassName());
        e1.setClassName("XYZ");
        Assert.assertEquals((Object)"XYZ", (Object)e1.getClassName());
        Embeddable e2 = new Embeddable("ABC");
        Assert.assertEquals((Object)"ABC", (Object)e2.getClassName());
    }

    @Test
    public void testAddAttribute() {
        Embeddable e1 = new Embeddable();
        EmbeddableAttribute a1 = new EmbeddableAttribute("a1");
        EmbeddableAttribute a2 = new EmbeddableAttribute("a2");
        Assert.assertEquals((long)0L, (long)e1.getAttributeMap().size());
        e1.addAttribute(a1);
        Assert.assertEquals((long)1L, (long)e1.getAttributeMap().size());
        Assert.assertSame((Object)e1, (Object)a1.getEmbeddable());
        e1.addAttribute(a2);
        Assert.assertEquals((long)2L, (long)e1.getAttributeMap().size());
        Assert.assertSame((Object)e1, (Object)a2.getEmbeddable());
        Assert.assertTrue((boolean)e1.getAttributes().contains(a1));
        Assert.assertTrue((boolean)e1.getAttributes().contains(a2));
    }

    @Test
    public void testRemoveAttribute() {
        Embeddable e1 = new Embeddable();
        EmbeddableAttribute a1 = new EmbeddableAttribute("a1");
        EmbeddableAttribute a2 = new EmbeddableAttribute("a2");
        e1.addAttribute(a1);
        e1.addAttribute(a2);
        e1.removeAttribute("a1");
        e1.removeAttribute("a2");
        Assert.assertEquals((long)0L, (long)e1.getAttributeMap().size());
        Assert.assertFalse((boolean)e1.getAttributes().contains(a1));
        Assert.assertFalse((boolean)e1.getAttributes().contains(a2));
    }
}

