/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTAdd;
import org.apache.cayenne.exp.parser.ASTDivide;
import org.apache.cayenne.exp.parser.ASTFalse;
import org.apache.cayenne.exp.parser.ASTMultiply;
import org.apache.cayenne.exp.parser.ASTNegate;
import org.apache.cayenne.exp.parser.ASTSubtract;
import org.apache.cayenne.exp.parser.ASTTrue;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionEvaluateInMemoryTest {
    @Test
    public void testEvaluateADD() {
        ASTAdd add = new ASTAdd(new Object[]{new Integer(1), new Double(5.5)});
        Assert.assertEquals((double)6.5, (double)((Number)((Expression)add).evaluate(null)).doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testEvaluateSubtract() {
        ASTSubtract subtract = new ASTSubtract(new Object[]{new Integer(1), new Double(0.1), new Double(0.2)});
        Assert.assertEquals((double)0.7, (double)((Number)((Expression)subtract).evaluate(null)).doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testEvaluateMultiply() {
        ASTMultiply multiply = new ASTMultiply(new Object[]{new Integer(2), new Double(3.5)});
        Assert.assertEquals((double)7.0, (double)((Number)((Expression)multiply).evaluate(null)).doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testEvaluateDivide() {
        ASTDivide divide = new ASTDivide(new Object[]{new BigDecimal("7.0"), new BigDecimal("2.0")});
        Assert.assertEquals((double)3.5, (double)((Number)((Expression)divide).evaluate(null)).doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testEvaluateNegate() {
        Assert.assertEquals((long)-3L, (long)((Number)new ASTNegate(new Integer(3)).evaluate(null)).intValue());
        Assert.assertEquals((long)5L, (long)((Number)new ASTNegate(new Integer(-5)).evaluate(null)).intValue());
    }

    @Test
    public void testEvaluateTrue() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)new ASTTrue().evaluate(null));
    }

    @Test
    public void testEvaluateFalse() {
        Assert.assertEquals((Object)Boolean.FALSE, (Object)new ASTFalse().evaluate(null));
    }
}

