/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import org.apache.cayenne.exp.parser.ASTLikeIgnoreCase;
import org.apache.cayenne.exp.parser.ASTNotLikeIgnoreCase;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Test;

public class ASTLikeIgnoreCaseTest {
    @Test
    public void testToEJBQL() {
        ASTLikeIgnoreCase like = new ASTLikeIgnoreCase(new ASTObjPath("a"), "%b%");
        Assert.assertEquals((Object)like.toEJBQL("p"), (Object)"upper(p.a) like '%B%'");
    }

    @Test
    public void testEvaluate() {
        ASTLikeIgnoreCase like = new ASTLikeIgnoreCase(new ASTObjPath("artistName"), "aBcD");
        ASTNotLikeIgnoreCase notLike = new ASTNotLikeIgnoreCase(new ASTObjPath("artistName"), "aBcD");
        Artist noMatch1 = new Artist();
        noMatch1.setArtistName("dabc");
        Assert.assertFalse((boolean)like.match(noMatch1));
        Assert.assertTrue((boolean)notLike.match(noMatch1));
        Artist match1 = new Artist();
        match1.setArtistName("abcd");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match1));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match1));
        Artist match2 = new Artist();
        match2.setArtistName("ABcD");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match2));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match2));
    }
}

