/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.mysql.MySQLAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbKeyGenerator;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class JdbcAdapterIT
extends ServerCase {
    @Inject
    private DbAdapter dbAdapter;
    @Inject
    private AdhocObjectFactory objectFactory;

    @Test
    public void testExternalTypesForJdbcType() throws Exception {
        this.checkType(2004);
        this.checkType(2003);
        this.checkType(91);
        this.checkType(12);
    }

    private void checkType(int type) throws Exception {
        JdbcAdapter adapter = (JdbcAdapter)this.objectFactory.newInstance(JdbcAdapter.class, JdbcAdapter.class.getName());
        String[] types = adapter.externalTypesForJdbcType(type);
        Assert.assertNotNull((Object)types);
        Assert.assertEquals((long)1L, (long)types.length);
        Assert.assertEquals((Object)TypesMapping.getSqlNameByType(type), (Object)types[0]);
    }

    @Test
    public void testCreateTableQuoteSqlIdentifiers() {
        if (this.dbAdapter instanceof MySQLAdapter) {
            DbEntity entity = new DbEntity();
            DbAttribute attr = new DbAttribute();
            attr.setName("name column");
            attr.setType(1);
            entity.addAttribute(attr);
            DbKeyGenerator id = new DbKeyGenerator();
            entity.setPrimaryKeyGenerator(id);
            DataMap dm = new DataMap();
            dm.setQuotingSQLIdentifiers(true);
            entity.setDataMap(dm);
            entity.setName("name table");
            MySQLAdapter adaptMySQL = (MySQLAdapter)this.dbAdapter;
            String str = "CREATE TABLE `name table` (`name column` CHAR NULL) ENGINE=InnoDB";
            Assert.assertEquals((Object)str, (Object)adaptMySQL.createTable(entity));
        }
    }
}

