/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.datasource.DataSourceBuilder;
import org.apache.cayenne.datasource.ManagedPoolingDataSource;
import org.apache.cayenne.datasource.PoolingDataSource;
import org.apache.cayenne.datasource.PoolingDataSourceParameters;
import org.apache.cayenne.datasource.UnmanagedPoolingDataSource;

public class PoolingDataSourceBuilder {
    private DataSourceBuilder nonPoolingBuilder;
    private PoolingDataSourceParameters poolParameters;

    public PoolingDataSourceBuilder(DataSourceBuilder nonPoolingBuilder) {
        this.nonPoolingBuilder = nonPoolingBuilder;
        this.poolParameters = new PoolingDataSourceParameters();
        this.poolParameters.setMinConnections(1);
        this.poolParameters.setMaxConnections(1);
        this.poolParameters.setMaxQueueWaitTime(20000L);
    }

    public PoolingDataSourceBuilder minConnections(int minConnections) {
        this.poolParameters.setMinConnections(minConnections);
        return this;
    }

    public PoolingDataSourceBuilder maxConnections(int maxConnections) {
        this.poolParameters.setMaxConnections(maxConnections);
        return this;
    }

    public PoolingDataSourceBuilder maxQueueWaitTime(long maxQueueWaitTime) {
        this.poolParameters.setMaxQueueWaitTime(maxQueueWaitTime);
        return this;
    }

    public PoolingDataSourceBuilder validationQuery(String validationQuery) {
        this.poolParameters.setValidationQuery(validationQuery);
        return this;
    }

    public PoolingDataSource build() {
        if (this.poolParameters.getMaxConnections() < 0) {
            throw new CayenneRuntimeException("Maximum number of connections can not be negative (" + this.poolParameters.getMaxConnections() + ").", new Object[0]);
        }
        if (this.poolParameters.getMinConnections() < 0) {
            throw new CayenneRuntimeException("Minimum number of connections can not be negative (" + this.poolParameters.getMinConnections() + ").", new Object[0]);
        }
        if (this.poolParameters.getMinConnections() > this.poolParameters.getMaxConnections()) {
            throw new CayenneRuntimeException("Minimum number of connections can not be bigger then maximum.", new Object[0]);
        }
        DataSource nonPooling = this.nonPoolingBuilder.build();
        return this.buildManaged(this.buildPooling(nonPooling));
    }

    private UnmanagedPoolingDataSource buildPooling(DataSource nonPoolingDataSource) {
        return new UnmanagedPoolingDataSource(nonPoolingDataSource, this.poolParameters);
    }

    private PoolingDataSource buildManaged(UnmanagedPoolingDataSource dataSource) {
        return new ManagedPoolingDataSource(dataSource);
    }
}

