/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import java.io.Serializable;
import org.apache.cayenne.configuration.PasswordEncoding;
import org.apache.cayenne.configuration.PlainTextPasswordEncoder;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceInfo
implements Cloneable,
Serializable,
XMLSerializable {
    private static final long serialVersionUID = 3748394113864532902L;
    private static Log logger = LogFactory.getLog(DataSourceInfo.class);
    public static final String PASSWORD_LOCATION_CLASSPATH = "classpath";
    public static final String PASSWORD_LOCATION_EXECUTABLE = "executable";
    public static final String PASSWORD_LOCATION_MODEL = "model";
    public static final String PASSWORD_LOCATION_URL = "url";
    protected String userName;
    protected String password;
    protected String jdbcDriver;
    protected String dataSourceUrl;
    protected String adapterClassName;
    protected int minConnections = 1;
    protected int maxConnections = 1;
    protected String passwordEncoderClass = PlainTextPasswordEncoder.class.getName();
    protected String passwordEncoderKey = "";
    protected String passwordLocation = "model";
    protected String passwordSourceExecutable = "";
    protected String passwordSourceFilename = "";
    protected final String passwordSourceModel = "Not Applicable";
    protected String passwordSourceUrl = "";

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DataSourceInfo dsi = (DataSourceInfo)obj;
        if (!Util.nullSafeEquals(this.userName, dsi.userName)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.password, dsi.password)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.jdbcDriver, dsi.jdbcDriver)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.dataSourceUrl, dsi.dataSourceUrl)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.adapterClassName, dsi.adapterClassName)) {
            return false;
        }
        if (this.minConnections != dsi.minConnections) {
            return false;
        }
        if (this.maxConnections != dsi.maxConnections) {
            return false;
        }
        if (!Util.nullSafeEquals(this.passwordEncoderClass, dsi.passwordEncoderClass)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.passwordEncoderKey, dsi.passwordEncoderKey)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.passwordSourceFilename, dsi.passwordSourceFilename)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.passwordSourceModel, dsi.passwordSourceModel)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.passwordSourceUrl, dsi.passwordSourceUrl)) {
            return false;
        }
        return Util.nullSafeEquals(this.passwordLocation, dsi.passwordLocation);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        String passwordSource;
        PasswordEncoding passwordEncoder;
        encoder.println("<data-source>");
        encoder.indent(1);
        encoder.print("<driver");
        encoder.printAttribute("value", this.jdbcDriver);
        encoder.println("/>");
        encoder.print("<url");
        encoder.printAttribute("value", this.dataSourceUrl);
        encoder.println("/>");
        encoder.print("<connectionPool");
        encoder.printAttribute("min", String.valueOf(this.minConnections));
        encoder.printAttribute("max", String.valueOf(this.maxConnections));
        encoder.println("/>");
        encoder.print("<login");
        encoder.printAttribute("userName", this.userName);
        if (PASSWORD_LOCATION_MODEL.equals(this.passwordLocation) && (passwordEncoder = this.getPasswordEncoder()) != null) {
            String passwordEncoded = passwordEncoder.encodePassword(this.password, this.passwordEncoderKey);
            encoder.printAttribute("password", passwordEncoded);
        }
        if (!PlainTextPasswordEncoder.class.getName().equals(this.passwordEncoderClass)) {
            encoder.printAttribute("encoderClass", this.passwordEncoderClass);
        }
        encoder.printAttribute("encoderKey", this.passwordEncoderKey);
        if (!PASSWORD_LOCATION_MODEL.equals(this.passwordLocation)) {
            encoder.printAttribute("passwordLocation", this.passwordLocation);
        }
        if (!"Not Applicable".equals(passwordSource = this.getPasswordSource())) {
            encoder.printAttribute("passwordSource", passwordSource);
        }
        encoder.println("/>");
        encoder.indent(-1);
        encoder.println("</data-source>");
    }

    public DataSourceInfo cloneInfo() {
        try {
            return (DataSourceInfo)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Cloning error", ex);
        }
    }

    public String getAdapterClassName() {
        return this.adapterClassName;
    }

    public void setAdapterClassName(String adapterClassName) {
        this.adapterClassName = adapterClassName;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setDataSourceUrl(String dataSourceUrl) {
        this.dataSourceUrl = dataSourceUrl;
    }

    public String getDataSourceUrl() {
        return this.dataSourceUrl;
    }

    @Deprecated
    public PasswordEncoding getPasswordEncoder() {
        try {
            return (PasswordEncoding)Util.getJavaClass(this.getPasswordEncoderClass()).newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (DIRuntimeException dIRuntimeException) {
            // empty catch block
        }
        logger.error((Object)("Failed to obtain specified Password Encoder '" + this.getPasswordEncoderClass() + "'"));
        return null;
    }

    public String getPasswordEncoderClass() {
        return this.passwordEncoderClass;
    }

    public void setPasswordEncoderClass(String passwordEncoderClass) {
        this.passwordEncoderClass = passwordEncoderClass == null ? PasswordEncoding.standardEncoders[0] : passwordEncoderClass;
    }

    public String getPasswordEncoderKey() {
        return this.passwordEncoderKey;
    }

    public void setPasswordEncoderKey(String passwordEncoderKey) {
        this.passwordEncoderKey = passwordEncoderKey;
    }

    public String getPasswordSourceFilename() {
        return this.passwordSourceFilename;
    }

    public void setPasswordSourceFilename(String passwordSourceFilename) {
        this.passwordSourceFilename = passwordSourceFilename;
    }

    public String getPasswordSourceModel() {
        return "Not Applicable";
    }

    public String getPasswordSourceUrl() {
        return this.passwordSourceUrl;
    }

    public void setPasswordSourceUrl(String passwordSourceUrl) {
        this.passwordSourceUrl = passwordSourceUrl;
    }

    public String getPasswordSourceExecutable() {
        return this.passwordSourceExecutable;
    }

    public void setPasswordSourceExecutable(String passwordSourceExecutable) {
        this.passwordSourceExecutable = passwordSourceExecutable;
    }

    public String getPasswordSource() {
        if (this.getPasswordLocation().equals(PASSWORD_LOCATION_CLASSPATH)) {
            return this.getPasswordSourceFilename();
        }
        if (this.getPasswordLocation().equals(PASSWORD_LOCATION_EXECUTABLE)) {
            return this.getPasswordSourceExecutable();
        }
        if (this.getPasswordLocation().equals(PASSWORD_LOCATION_MODEL)) {
            return this.getPasswordSourceModel();
        }
        if (this.getPasswordLocation().equals(PASSWORD_LOCATION_URL)) {
            return this.getPasswordSourceUrl();
        }
        throw new RuntimeException("Invalid password source detected");
    }

    public void setPasswordSource(String passwordSource) {
        if (this.getPasswordLocation().equals(PASSWORD_LOCATION_CLASSPATH)) {
            this.setPasswordSourceFilename(passwordSource);
        } else if (this.getPasswordLocation().equals(PASSWORD_LOCATION_EXECUTABLE)) {
            this.setPasswordSourceExecutable(passwordSource);
        } else if (this.getPasswordLocation().equals(PASSWORD_LOCATION_URL)) {
            this.setPasswordSourceUrl(passwordSource);
        }
    }

    public String getPasswordLocation() {
        return this.passwordLocation;
    }

    public void setPasswordLocation(String passwordLocation) {
        this.passwordLocation = passwordLocation == null ? PASSWORD_LOCATION_MODEL : passwordLocation;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[").append(this.getClass().getName()).append(":").append("\n   user name: ").append(this.userName).append("\n   password: ");
        buffer.append("**********");
        buffer.append("\n   driver: ").append(this.jdbcDriver).append("\n   db adapter class: ").append(this.adapterClassName).append("\n   url: ").append(this.dataSourceUrl).append("\n   min. connections: ").append(this.minConnections).append("\n   max. connections: ").append(this.maxConnections);
        if (!PlainTextPasswordEncoder.class.getName().equals(this.passwordEncoderClass)) {
            buffer.append("\n   encoder class: ").append(this.passwordEncoderClass).append("\n   encoder key: ").append(this.passwordEncoderKey);
        }
        if (!PASSWORD_LOCATION_MODEL.equals(this.passwordLocation)) {
            buffer.append("\n   password location: ").append(this.passwordLocation).append("\n   password source: ").append(this.getPasswordSource());
        }
        buffer.append("\n]");
        return buffer.toString();
    }
}

