/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.web;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cayenne.BaseContext;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.configuration.web.RequestHandler;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;

public class SessionContextRequestHandler
implements RequestHandler {
    static final String SESSION_CONTEXT_KEY = SessionContextRequestHandler.class.getName() + ".SESSION_CONTEXT";
    @Inject
    private Injector injector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStart(ServletRequest request, ServletResponse response) {
        CayenneRuntime.bindThreadInjector(this.injector);
        if (request instanceof HttpServletRequest) {
            ObjectContext context;
            HttpSession session;
            HttpSession httpSession = session = ((HttpServletRequest)request).getSession();
            synchronized (httpSession) {
                context = (ObjectContext)session.getAttribute(SESSION_CONTEXT_KEY);
                if (context == null) {
                    context = ((ObjectContextFactory)this.injector.getInstance(ObjectContextFactory.class)).createContext();
                    session.setAttribute(SESSION_CONTEXT_KEY, (Object)context);
                }
            }
            BaseContext.bindThreadObjectContext(context);
        }
    }

    @Override
    public void requestEnd(ServletRequest request, ServletResponse response) {
        CayenneRuntime.bindThreadInjector(null);
        BaseContext.bindThreadObjectContext(null);
    }
}

