/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.validation.ValidationException;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class NestedDataContextValidationIT
extends ServerCase {
    @Inject
    protected ServerRuntime runtime;
    @Inject
    private DataContext context;

    @Test
    public void testValidateOnCommitToParent() {
        this.context.setValidatingObjectsOnCommit(true);
        ObjectContext childContext = this.runtime.newContext(this.context);
        Assert.assertTrue((String)"Child context must have inherited the validation flag from parent", (boolean)((DataContext)childContext).isValidatingObjectsOnCommit());
        Artist a1 = childContext.newObject(Artist.class);
        try {
            childContext.commitChangesToParent();
            Assert.fail((String)"No validation was performed");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.context.hasChanges());
        a1.setArtistName("T");
        childContext.commitChangesToParent();
    }
}

