/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.IncrementalFaultList;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.frontbase.FrontBaseAdapter;
import org.apache.cayenne.dba.openbase.OpenBaseAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResult;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.unit.util.SQLTemplateCustomizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextSQLTemplateIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected SQLTemplateCustomizer sqlTemplateCustomizer;
    protected TableHelper tPainting;
    protected TableHelper tArtist;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, 12, -5, 3});
    }

    protected void createFourArtists() throws Exception {
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tArtist.insert(new Object[]{101, "artist3"});
        this.tArtist.insert(new Object[]{201, "artist4"});
        this.tArtist.insert(new Object[]{3001, "artist5"});
    }

    protected void createFourArtistsAndThreePaintingsDataSet() throws Exception {
        this.createFourArtists();
        this.tPainting.insert(new Object[]{6, "p_artist3", 11, 1000});
        this.tPainting.insert(new Object[]{7, "p_artist2", 101, 2000});
        this.tPainting.insert(new Object[]{8, "p_artist4", null, 3000});
    }

    @Test
    public void testSQLResultSetMappingMixed() throws Exception {
        this.createFourArtistsAndThreePaintingsDataSet();
        String sql = "SELECT #result('t0.ARTIST_ID' 'long' 'X'), #result('t0.ARTIST_NAME' 'String' 'Y'), #result('t0.DATE_OF_BIRTH' 'Date' 'Z'), #result('count(t1.PAINTING_ID)' 'int' 'C') FROM ARTIST t0 LEFT JOIN PAINTING t1 ON (t0.ARTIST_ID = t1.ARTIST_ID) GROUP BY t0.ARTIST_ID, t0.ARTIST_NAME, t0.DATE_OF_BIRTH ORDER BY t0.ARTIST_ID";
        DataMap map = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate query = new SQLTemplate(map, sql, false);
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        EntityResult artistResult = new EntityResult(Artist.class);
        artistResult.addDbField("ARTIST_ID", "X");
        artistResult.addObjectField("artistName", "Y");
        artistResult.addObjectField("dateOfBirth", "Z");
        SQLResult rsMap = new SQLResult();
        rsMap.addEntityResult(artistResult);
        rsMap.addColumnResult("C");
        query.setResult(rsMap);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)4L, (long)objects.size());
        Object o1 = objects.get(0);
        Assert.assertTrue((String)("Expected Object[]: " + o1), (boolean)(o1 instanceof Object[]));
        Object[] array1 = (Object[])o1;
        Assert.assertEquals((long)2L, (long)array1.length);
        Object[] array2 = (Object[])objects.get(1);
        Assert.assertEquals((long)2L, (long)array2.length);
        Object[] array3 = (Object[])objects.get(2);
        Assert.assertEquals((long)2L, (long)array3.length);
        Object[] array4 = (Object[])objects.get(3);
        Assert.assertEquals((long)2L, (long)array3.length);
        Assert.assertEquals((Object)new Integer(1), (Object)array1[1]);
        Assert.assertEquals((Object)new Integer(1), (Object)array2[1]);
        Assert.assertEquals((Object)new Integer(0), (Object)array3[1]);
        Assert.assertEquals((Object)new Integer(0), (Object)array4[1]);
        Assert.assertTrue((String)("Unexpected DataObject: " + array1[0]), (boolean)(array1[0] instanceof Artist));
    }

    @Test
    public void testRootless_DataNodeName() throws Exception {
        this.createFourArtists();
        SQLTemplate query = new SQLTemplate("SELECT * FROM ARTIST", true);
        query.setDataNodeName("testmap");
        Assert.assertEquals((long)4L, (long)this.context.performQuery(query).size());
    }

    @Test
    public void testRootless_DefaultDataNode() throws Exception {
        this.createFourArtists();
        SQLTemplate query = new SQLTemplate("SELECT * FROM ARTIST", true);
        Assert.assertEquals((long)4L, (long)this.context.performQuery(query).size());
    }

    @Test
    public void testSQLResultSetMappingScalar() throws Exception {
        this.createFourArtists();
        String sql = "SELECT count(1) AS X FROM ARTIST";
        DataMap map = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate query = new SQLTemplate(map, sql, false);
        query.setTemplate(FrontBaseAdapter.class.getName(), "SELECT COUNT(ARTIST_ID) X FROM ARTIST");
        query.setTemplate(OpenBaseAdapter.class.getName(), "SELECT COUNT(ARTIST_ID) X FROM ARTIST");
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        SQLResult rsMap = new SQLResult();
        rsMap.addColumnResult("X");
        query.setResult(rsMap);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Object o = objects.get(0);
        Assert.assertTrue((String)("Expected Number: " + o), (boolean)(o instanceof Number));
        Assert.assertEquals((long)4L, (long)((Number)o).intValue());
    }

    @Test
    public void testSQLResultSetMappingScalarArray() throws Exception {
        this.createFourArtists();
        String sql = "SELECT count(1) AS X, 77 AS Y FROM ARTIST";
        DataMap map = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate query = new SQLTemplate(map, sql, false);
        query.setTemplate(FrontBaseAdapter.class.getName(), "SELECT COUNT(ARTIST_ID) X, 77 Y FROM ARTIST GROUP BY Y");
        query.setTemplate(OpenBaseAdapter.class.getName(), "SELECT COUNT(ARTIST_ID) X, 77 Y FROM ARTIST GROUP BY 77");
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        SQLResult rsMap = new SQLResult();
        rsMap.addColumnResult("X");
        rsMap.addColumnResult("Y");
        query.setResult(rsMap);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Object o = objects.get(0);
        Assert.assertTrue((boolean)(o instanceof Object[]));
        Object[] row = (Object[])o;
        Assert.assertEquals((long)2L, (long)row.length);
        Assert.assertEquals((long)4L, (long)((Number)row[0]).intValue());
        Assert.assertEquals((long)77L, (long)((Number)row[1]).intValue());
    }

    @Test
    public void testColumnNamesCapitalization() throws Exception {
        this.createFourArtistsAndThreePaintingsDataSet();
        String template = "SELECT * FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = new SQLTemplate(Artist.class, template);
        query.setColumnNamesCapitalization(CapsStrategy.LOWER);
        query.setFetchingDataRows(true);
        List rows = this.context.performQuery(query);
        DataRow row1 = (DataRow)rows.get(0);
        Assert.assertFalse((boolean)row1.containsKey("ARTIST_ID"));
        Assert.assertTrue((boolean)row1.containsKey("artist_id"));
        DataRow row2 = (DataRow)rows.get(1);
        Assert.assertFalse((boolean)row2.containsKey("ARTIST_ID"));
        Assert.assertTrue((boolean)row2.containsKey("artist_id"));
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        List rowsUpper = this.context.performQuery(query);
        DataRow row3 = (DataRow)rowsUpper.get(0);
        Assert.assertFalse((boolean)row3.containsKey("artist_id"));
        Assert.assertTrue((boolean)row3.containsKey("ARTIST_ID"));
        DataRow row4 = (DataRow)rowsUpper.get(1);
        Assert.assertFalse((boolean)row4.containsKey("artist_id"));
        Assert.assertTrue((boolean)row4.containsKey("ARTIST_ID"));
    }

    @Test
    public void testFetchDataRows() throws Exception {
        this.createFourArtists();
        String template = "SELECT * FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = new SQLTemplate(Artist.class, template);
        this.sqlTemplateCustomizer.updateSQLTemplate(query);
        query.setFetchingDataRows(true);
        List rows = this.context.performQuery(query);
        Assert.assertEquals((long)4L, (long)rows.size());
        DataRow row2 = (DataRow)rows.get(1);
        Assert.assertEquals((long)3L, (long)row2.size());
        Object id = row2.get("ARTIST_ID");
        Assert.assertEquals((Object)new Integer(101), (Object)new Integer(id.toString()));
    }

    @Test
    public void testFetchObjects() throws Exception {
        this.createFourArtists();
        String template = "SELECT * FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = this.sqlTemplateCustomizer.createSQLTemplate(Artist.class, template);
        query.setFetchingDataRows(false);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)4L, (long)objects.size());
        Assert.assertTrue((boolean)(objects.get(1) instanceof Artist));
        Artist artist2 = (Artist)objects.get(1);
        Assert.assertEquals((Object)"artist3", (Object)artist2.getArtistName());
    }

    @Test
    public void testBindObjectEqualShort() throws Exception {
        this.createFourArtistsAndThreePaintingsDataSet();
        Artist a = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 101);
        String template = "SELECT * FROM PAINTING WHERE #bindObjectEqual($a) ORDER BY PAINTING_ID";
        SQLTemplate query = new SQLTemplate(Painting.class, template);
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        query.setParameters(Collections.singletonMap("a", a));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Painting p = (Painting)objects.get(0);
        Assert.assertEquals((long)7L, (long)Cayenne.intPKForObject(p));
    }

    @Test
    public void testBindObjectNotEqualShort() throws Exception {
        this.createFourArtistsAndThreePaintingsDataSet();
        Artist a = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 101);
        String template = "SELECT * FROM PAINTING WHERE #bindObjectNotEqual($a) ORDER BY PAINTING_ID";
        SQLTemplate query = new SQLTemplate(Painting.class, template);
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        query.setParameters(Collections.singletonMap("a", a));
        List objects = this.context.performQuery(query);
        Assert.assertTrue((objects.size() == 1 || objects.size() == 2 ? 1 : 0) != 0);
        Painting p = (Painting)objects.get(0);
        Assert.assertEquals((long)6L, (long)Cayenne.intPKForObject(p));
    }

    @Test
    public void testBindObjectEqualFull() throws Exception {
        this.createFourArtistsAndThreePaintingsDataSet();
        Artist a = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 101);
        String template = "SELECT * FROM PAINTING t0 WHERE #bindObjectEqual($a [ 't0.ARTIST_ID' ] [ 'ARTIST_ID' ] ) ORDER BY PAINTING_ID";
        SQLTemplate query = new SQLTemplate(Painting.class, template);
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        query.setParameters(Collections.singletonMap("a", a));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Painting p = (Painting)objects.get(0);
        Assert.assertEquals((long)7L, (long)Cayenne.intPKForObject(p));
    }

    @Test
    public void testBindObjectEqualFullNonArray() throws Exception {
        this.createFourArtistsAndThreePaintingsDataSet();
        Artist a = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 101);
        String template = "SELECT * FROM PAINTING t0 WHERE #bindObjectEqual($a 't0.ARTIST_ID' 'ARTIST_ID' ) ORDER BY PAINTING_ID";
        SQLTemplate query = new SQLTemplate(Painting.class, template);
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        query.setParameters(Collections.singletonMap("a", a));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Painting p = (Painting)objects.get(0);
        Assert.assertEquals((long)7L, (long)Cayenne.intPKForObject(p));
    }

    @Test
    public void testBindObjectEqualNull() throws Exception {
        this.createFourArtistsAndThreePaintingsDataSet();
        String template = "SELECT * FROM PAINTING t0 WHERE #bindObjectEqual($a [ 't0.ARTIST_ID' ] [ 'ARTIST_ID' ] ) ORDER BY PAINTING_ID";
        SQLTemplate query = new SQLTemplate(Painting.class, template);
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        query.setParameters(Collections.singletonMap("a", null));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Painting p = (Painting)objects.get(0);
        Assert.assertEquals((long)8L, (long)Cayenne.intPKForObject(p));
    }

    @Test
    public void testBindObjectNotEqualFull() throws Exception {
        this.createFourArtistsAndThreePaintingsDataSet();
        Artist a = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 101);
        String template = "SELECT * FROM PAINTING t0 WHERE #bindObjectNotEqual($a [ 't0.ARTIST_ID' ] [ 'ARTIST_ID' ] ) ORDER BY PAINTING_ID";
        SQLTemplate query = new SQLTemplate(Painting.class, template);
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        query.setParameters(Collections.singletonMap("a", a));
        List objects = this.context.performQuery(query);
        Assert.assertTrue((objects.size() == 1 || objects.size() == 2 ? 1 : 0) != 0);
        Painting p = (Painting)objects.get(0);
        Assert.assertEquals((long)6L, (long)Cayenne.intPKForObject(p));
    }

    @Test
    public void testBindObjectNotEqualNull() throws Exception {
        this.createFourArtistsAndThreePaintingsDataSet();
        String template = "SELECT * FROM PAINTING t0 WHERE #bindObjectNotEqual($a [ 't0.ARTIST_ID' ] [ 'ARTIST_ID' ] ) ORDER BY PAINTING_ID";
        SQLTemplate query = new SQLTemplate(Painting.class, template);
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        query.setParameters(Collections.singletonMap("a", null));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        Painting p1 = (Painting)objects.get(0);
        Assert.assertEquals((long)6L, (long)Cayenne.intPKForObject(p1));
        Painting p2 = (Painting)objects.get(1);
        Assert.assertEquals((long)7L, (long)Cayenne.intPKForObject(p2));
    }

    @Test
    public void testBindEqualNull() throws Exception {
        this.createFourArtistsAndThreePaintingsDataSet();
        String template = "SELECT * FROM PAINTING t0 WHERE t0.ARTIST_ID #bindEqual($id) ORDER BY PAINTING_ID";
        SQLTemplate query = new SQLTemplate(Painting.class, template);
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        query.setParameters(Collections.singletonMap("id", null));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Painting p = (Painting)objects.get(0);
        Assert.assertEquals((long)8L, (long)Cayenne.intPKForObject(p));
    }

    @Test
    public void testFetchLimit() throws Exception {
        this.createFourArtists();
        int fetchLimit = 2;
        Assert.assertTrue((fetchLimit < 4 ? 1 : 0) != 0);
        String template = "SELECT * FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = this.sqlTemplateCustomizer.createSQLTemplate(Artist.class, template);
        query.setFetchLimit(fetchLimit);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)fetchLimit, (long)objects.size());
        Assert.assertTrue((boolean)(objects.get(0) instanceof Artist));
    }

    @Test
    public void testFetchOffset() throws Exception {
        this.createFourArtists();
        int fetchOffset = 2;
        Assert.assertTrue((fetchOffset < 4 ? 1 : 0) != 0);
        String template = "SELECT * FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = this.sqlTemplateCustomizer.createSQLTemplate(Artist.class, template);
        query.setFetchOffset(fetchOffset);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)(4 - fetchOffset), (long)objects.size());
        Assert.assertTrue((boolean)(objects.get(0) instanceof Artist));
    }

    @Test
    public void testFetchOffsetFetchLimit() throws Exception {
        this.createFourArtists();
        String template = "SELECT * FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = this.sqlTemplateCustomizer.createSQLTemplate(Artist.class, template);
        query.setFetchOffset(1);
        query.setFetchLimit(2);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertTrue((boolean)(objects.get(0) instanceof Artist));
    }

    @Test
    public void testPageSize() throws Exception {
        this.createFourArtists();
        int pageSize = 3;
        Assert.assertTrue((pageSize < 4 ? 1 : 0) != 0);
        String template = "SELECT * FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = this.sqlTemplateCustomizer.createSQLTemplate(Artist.class, template);
        query.setPageSize(pageSize);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)4L, (long)objects.size());
        Assert.assertTrue((boolean)(objects.get(0) instanceof Artist));
        Assert.assertTrue((boolean)(objects instanceof IncrementalFaultList));
        IncrementalFaultList pagedList = (IncrementalFaultList)objects;
        Assert.assertEquals((long)(4 - pageSize), (long)pagedList.getUnfetchedObjects());
        Artist artist = (Artist)objects.get(pageSize);
        int expectUnresolved = 4 - pageSize - pageSize;
        if (expectUnresolved < 0) {
            expectUnresolved = 0;
        }
        Assert.assertEquals((long)expectUnresolved, (long)pagedList.getUnfetchedObjects());
        Assert.assertEquals((Object)("artist" + (pageSize + 2)), (Object)artist.getArtistName());
    }

    @Test
    public void testIteratedQuery() throws Exception {
        this.createFourArtists();
        String template = "SELECT * FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = this.sqlTemplateCustomizer.createSQLTemplate(Artist.class, template);
        try (ResultIterator it = this.context.performIteratedQuery(query);){
            long i = 0L;
            while (it.hasNextRow()) {
                DataRow row = (DataRow)it.nextRow();
                Assert.assertEquals((long)3L, (long)row.size());
                Assert.assertEquals((Object)("artist" + (1L + ++i)), row.get("ARTIST_NAME"));
            }
            Assert.assertEquals((long)4L, (long)i);
        }
    }

    @Test
    public void testQueryWithLineBreakAfterMacro() throws Exception {
        this.createFourArtists();
        String template = "SELECT #result('count(*)' 'int' 'X')" + System.getProperty("line.separator") + "FROM ARTIST";
        SQLTemplate query = this.sqlTemplateCustomizer.createSQLTemplate(Artist.class, template);
        query.setFetchingDataRows(true);
        List result = this.context.performQuery(query);
        Assert.assertEquals((Object)4, ((DataRow)result.get(0)).get("X"));
    }
}

