/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DeleteDenyException;
import org.apache.cayenne.FaultFailureException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectContextDeleteAction;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.cache.NestedQueryCache;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.exp.ValueInjector;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.ObjectContextGraphAction;

public abstract class BaseContext
implements ObjectContext {
    protected static final ThreadLocal<ObjectContext> threadObjectContext = new ThreadLocal();
    protected transient DataChannel channel;
    protected transient QueryCache queryCache;
    protected transient EntityResolver entityResolver;
    protected boolean validatingObjectsOnCommit = true;
    protected ObjectContextGraphAction graphAction = new ObjectContextGraphAction(this);
    protected volatile Map<String, Object> userProperties;

    public static ObjectContext getThreadObjectContext() throws IllegalStateException {
        ObjectContext context = threadObjectContext.get();
        if (context == null) {
            throw new IllegalStateException("Current thread has no bound ObjectContext.");
        }
        return context;
    }

    public static void bindThreadObjectContext(ObjectContext context) {
        threadObjectContext.set(context);
    }

    protected BaseContext() {
    }

    protected boolean attachToRuntimeIfNeeded() {
        if (this.channel != null) {
            return false;
        }
        Injector injector = CayenneRuntime.getThreadInjector();
        if (injector == null) {
            throw new CayenneRuntimeException("Can't attach to Cayenne runtime. Null injector returned from CayenneRuntime.getThreadInjector()", new Object[0]);
        }
        this.attachToRuntime(injector);
        return true;
    }

    protected void attachToRuntime(Injector injector) {
        this.attachToChannel((DataChannel)injector.getInstance(DataChannel.class));
        this.setQueryCache(new NestedQueryCache((QueryCache)injector.getInstance(QueryCache.class)));
    }

    protected void attachToChannel(DataChannel channel) {
        if (channel == null) {
            throw new NullPointerException("Null channel");
        }
        this.setChannel(channel);
        this.setEntityResolver(channel.getEntityResolver());
    }

    @Override
    public abstract void commitChanges();

    @Override
    public abstract void commitChangesToParent();

    @Override
    public void deleteObject(Object object) throws DeleteDenyException {
        this.deleteObjects(object);
    }

    @Override
    public abstract Collection<?> deletedObjects();

    @Override
    public DataChannel getChannel() {
        this.attachToRuntimeIfNeeded();
        return this.channel;
    }

    public void setChannel(DataChannel channel) {
        this.channel = channel;
    }

    @Override
    public EntityResolver getEntityResolver() {
        this.attachToRuntimeIfNeeded();
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public boolean isValidatingObjectsOnCommit() {
        return this.validatingObjectsOnCommit;
    }

    public void setValidatingObjectsOnCommit(boolean flag) {
        this.validatingObjectsOnCommit = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Persistent> T localObject(T objectFromAnotherContext) {
        if (objectFromAnotherContext == null) {
            throw new NullPointerException("Null object argument");
        }
        ObjectId id = objectFromAnotherContext.getObjectId();
        GraphManager graphManager = this.getGraphManager();
        synchronized (graphManager) {
            Persistent localObject = (Persistent)this.getGraphManager().getNode(id);
            if (localObject != null) {
                return (T)localObject;
            }
            ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
            Persistent persistent = (Persistent)descriptor.createObject();
            persistent.setObjectContext(this);
            persistent.setObjectId(id);
            persistent.setPersistenceState(5);
            this.getGraphManager().registerNode(id, persistent);
            return (T)persistent;
        }
    }

    @Override
    public abstract GraphManager getGraphManager();

    @Override
    public abstract Collection<?> modifiedObjects();

    @Override
    public abstract <T> T newObject(Class<T> var1);

    @Override
    public abstract void registerNewObject(Object var1);

    @Override
    public abstract Collection<?> newObjects();

    @Override
    public abstract QueryResponse performGenericQuery(Query var1);

    @Override
    public abstract List performQuery(Query var1);

    @Override
    public <T> List<T> select(Select<T> query) {
        return this.performQuery(query);
    }

    @Override
    public <T> T selectOne(Select<T> query) {
        List<T> objects = this.select(query);
        if (objects.size() == 0) {
            return null;
        }
        if (objects.size() > 1) {
            throw new CayenneRuntimeException("Expected zero or one object, instead query matched: " + objects.size(), new Object[0]);
        }
        return objects.get(0);
    }

    @Override
    public <T> T selectFirst(Select<T> query) {
        List<T> objects = this.select(query);
        return objects == null || objects.isEmpty() ? null : (T)objects.get(0);
    }

    @Override
    public <T> void iterate(Select<T> query, ResultIteratorCallback<T> callback) {
        try (ResultIterator<T> it = this.iterator(query);){
            for (Object t : it) {
                callback.next(t);
            }
        }
    }

    @Override
    public abstract <T> ResultIterator<T> iterator(Select<T> var1);

    @Override
    public <T> ResultBatchIterator<T> batchIterator(Select<T> query, int size) {
        return new ResultBatchIterator<T>(this.iterator(query), size);
    }

    @Override
    public void prepareForAccess(Persistent object, String property, boolean lazyFaulting) {
        if (object.getPersistenceState() == 5) {
            ObjectId oid = object.getObjectId();
            List objects = this.performQuery(new ObjectIdQuery(oid, false, 1));
            if (objects.size() == 0) {
                throw new FaultFailureException("Error resolving fault, no matching row exists in the database for ObjectId: " + oid, new Object[0]);
            }
            if (objects.size() > 1) {
                throw new FaultFailureException("Error resolving fault, more than one row exists in the database for ObjectId: " + oid, new Object[0]);
            }
        }
        if (lazyFaulting && property != null) {
            ClassDescriptor classDescriptor = this.getEntityResolver().getClassDescriptor(object.getObjectId().getEntityName());
            PropertyDescriptor propertyDescriptor = classDescriptor.getProperty(property);
            if (propertyDescriptor == null) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append(String.format("Property '%s' is not declared for entity '%s'.", property, object.getObjectId().getEntityName()));
                errorMessage.append(" Declared properties are: ");
                final ArrayList properties = new ArrayList();
                classDescriptor.visitProperties(new PropertyVisitor(){

                    @Override
                    public boolean visitAttribute(AttributeProperty property) {
                        properties.add(property.getName());
                        return true;
                    }

                    @Override
                    public boolean visitToOne(ToOneProperty property) {
                        properties.add(property.getName());
                        return true;
                    }

                    @Override
                    public boolean visitToMany(ToManyProperty property) {
                        properties.add(property.getName());
                        return true;
                    }
                });
                boolean first = true;
                for (String declaredProperty : properties) {
                    if (first) {
                        errorMessage.append(String.format("'%s'", declaredProperty));
                        first = false;
                        continue;
                    }
                    errorMessage.append(String.format(", '%s'", declaredProperty));
                }
                errorMessage.append(".");
                throw new CayenneRuntimeException(errorMessage.toString(), new Object[0]);
            }
            propertyDescriptor.readProperty(object);
        }
    }

    @Override
    public void propertyChanged(Persistent object, String property, Object oldValue, Object newValue) {
        this.graphAction.handlePropertyChange(object, property, oldValue, newValue);
    }

    @Override
    public abstract void rollbackChanges();

    @Override
    public abstract void rollbackChangesLocally();

    @Override
    public abstract Collection<?> uncommittedObjects();

    public QueryCache getQueryCache() {
        this.attachToRuntimeIfNeeded();
        return this.queryCache;
    }

    public void setQueryCache(QueryCache queryCache) {
        this.queryCache = queryCache;
    }

    @Override
    public EventManager getEventManager() {
        return this.channel != null ? this.channel.getEventManager() : null;
    }

    @Override
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        switch (syncType) {
            case 3: {
                return this.onContextRollback(originatingContext);
            }
            case 1: {
                return this.onContextFlush(originatingContext, changes, false);
            }
            case 2: {
                return this.onContextFlush(originatingContext, changes, true);
            }
        }
        throw new CayenneRuntimeException("Unrecognized SyncMessage type: " + syncType, new Object[0]);
    }

    GraphDiff onContextRollback(ObjectContext originatingContext) {
        this.rollbackChanges();
        return new CompoundDiff();
    }

    protected abstract GraphDiff onContextFlush(ObjectContext var1, GraphDiff var2, boolean var3);

    protected void fireDataChannelCommitted(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_FLUSHED_SUBJECT);
        }
    }

    protected void fireDataChannelRolledback(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_ROLLEDBACK_SUBJECT);
        }
    }

    protected void fireDataChannelChanged(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_CHANGED_SUBJECT);
        }
    }

    @Override
    public void invalidateObjects(Collection<?> objects) {
        if (objects == null) {
            throw new NullPointerException("Null collection of objects to invalidate");
        }
        if (!objects.isEmpty()) {
            this.performGenericQuery(new RefreshQuery(objects));
        }
    }

    @Override
    public <T> void invalidateObjects(T ... objects) {
        if (objects != null && objects.length > 0) {
            this.performGenericQuery(new RefreshQuery(Arrays.asList(objects)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getUserProperties() {
        if (this.userProperties == null) {
            BaseContext baseContext = this;
            synchronized (baseContext) {
                if (this.userProperties == null) {
                    this.userProperties = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        return this.userProperties;
    }

    @Override
    public Object getUserProperty(String key) {
        return this.getUserProperties().get(key);
    }

    @Override
    public void setUserProperty(String key, Object value) {
        this.getUserProperties().put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void injectInitialValue(Object obj) {
        ObjEntity entity;
        GraphManager graphManager;
        Persistent object = (Persistent)obj;
        object.setObjectContext(this);
        object.setPersistenceState(2);
        GraphManager graphManager2 = graphManager = this.getGraphManager();
        synchronized (graphManager2) {
            graphManager.registerNode(object.getObjectId(), object);
            graphManager.nodeCreated(object.getObjectId());
        }
        try {
            entity = this.getEntityResolver().getObjEntity(object.getClass());
        }
        catch (CayenneRuntimeException ex) {
            entity = null;
        }
        if (entity != null && entity.getDeclaredQualifier() instanceof ValueInjector) {
            ((ValueInjector)((Object)entity.getDeclaredQualifier())).injectValue(object);
        }
        this.getEntityResolver().getCallbackRegistry().performCallbacks(LifecycleEvent.POST_ADD, object);
    }

    @Override
    public <T> void deleteObjects(T ... objects) throws DeleteDenyException {
        if (objects == null || objects.length == 0) {
            return;
        }
        ObjectContextDeleteAction action = new ObjectContextDeleteAction(this);
        for (T object : objects) {
            action.performDelete((Persistent)object);
        }
    }

    @Override
    public void deleteObjects(Collection<?> objects) throws DeleteDenyException {
        if (objects.isEmpty()) {
            return;
        }
        ObjectContextDeleteAction action = new ObjectContextDeleteAction(this);
        ArrayList copy = new ArrayList(objects);
        for (Object object : copy) {
            action.performDelete((Persistent)object);
        }
    }
}

