/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.naming.NameConverter;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class CreateTableToModel
extends AbstractToModelToken.Entity {
    private String objEntityClassName = null;

    public CreateTableToModel(DbEntity entity) {
        super("Create Table", entity);
    }

    public void setObjEntityClassName(String n) {
        this.objEntityClassName = n;
    }

    @Override
    public void execute(MergerContext mergerContext) {
        String objEntityName;
        DataMap map = mergerContext.getDataMap();
        map.addDbEntity(this.getEntity());
        String baseName = objEntityName = NameConverter.underscoredToJava(this.getEntity().getName(), true);
        for (int i = 1; i < 1000 && map.getObjEntity(objEntityName) != null; ++i) {
            objEntityName = baseName + i;
        }
        ObjEntity objEntity = new ObjEntity(objEntityName);
        objEntity.setDbEntity(this.getEntity());
        String className = this.objEntityClassName;
        if (className == null) {
            className = map.getNameWithDefaultPackage(objEntityName);
        }
        objEntity.setClassName(className);
        objEntity.setSuperClassName(map.getDefaultSuperclass());
        if (map.isClientSupported()) {
            objEntity.setClientClassName(map.getNameWithDefaultClientPackage(objEntity.getName()));
            objEntity.setClientSuperClassName(map.getDefaultClientSuperclass());
        }
        map.addObjEntity(objEntity);
        this.synchronizeWithObjEntity(this.getEntity());
        mergerContext.getModelMergeDelegate().dbEntityAdded(this.getEntity());
        mergerContext.getModelMergeDelegate().objEntityAdded(objEntity);
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createDropTableToDb(this.getEntity());
    }
}

