/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.dbsync;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.dbsync.BaseSchemaUpdateStrategy;
import org.apache.cayenne.access.dbsync.SchemaAnalyzer;
import org.apache.cayenne.map.DbEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThrowOnPartialSchemaStrategy
extends BaseSchemaUpdateStrategy {
    static final Log logger = LogFactory.getLog(ThrowOnPartialSchemaStrategy.class);

    @Override
    protected void processSchemaUpdate(DataNode dataNode) throws SQLException {
        SchemaAnalyzer analyzer = new SchemaAnalyzer();
        ArrayList<String> schemas = new ArrayList<String>();
        DatabaseMetaData md = null;
        try {
            try (Connection connection = dataNode.getDataSource().getConnection();){
                md = connection.getMetaData();
                try (ResultSet rs = md.getSchemas();){
                    while (rs.next()) {
                        String schemaName = rs.getString(1);
                        schemas.add(schemaName);
                    }
                }
            }
            analyzer.analyzeSchemas(schemas, md);
        }
        catch (Exception e) {
            logger.debug((Object)"Exception analyzing schema, ignoring", (Throwable)e);
        }
        Collection<DbEntity> entities = dataNode.getEntityResolver().getDbEntities();
        boolean isIncluded = analyzer.compareTables(md, entities);
        if (isIncluded && analyzer.getErrorMessage() == null) {
            try {
                analyzer.compareColumns(md);
            }
            catch (SQLException e) {
                logger.debug((Object)"Exception analyzing schema, ignoring", (Throwable)e);
            }
        }
        this.processSchemaUpdate(dataNode, analyzer.getTableNoInDB(), analyzer.getErrorMessage(), entities.size());
    }

    protected void processSchemaUpdate(DataNode dataNode, List<String> mergerOnlyTable, String errorMessage, int entitiesSize) throws SQLException {
        if (mergerOnlyTable.size() != 0 || errorMessage != null) {
            logger.info((Object)"Error - missing or partial schema detected");
            StringBuilder buffer = new StringBuilder("Schema mismatch detected");
            if (errorMessage != null) {
                buffer.append(": ").append(errorMessage);
            } else if (mergerOnlyTable.size() == entitiesSize) {
                buffer.append(": no schema found");
            } else if (mergerOnlyTable.size() > 0) {
                buffer.append(": missing table '").append(mergerOnlyTable.get(0)).append('\'');
            }
            throw new CayenneRuntimeException(buffer.toString(), new Object[0]);
        }
        logger.info((Object)"Full schema is present");
    }
}

