/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.DeepMergeOperation;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DeepMergeOperationIT
extends ServerCase {
    @Inject
    private DataChannelInterceptor queryInterceptor;
    @Inject
    private DataContext context;
    @Inject
    private DataContext context1;

    @Test
    public void testDeepMergeNonExistent() {
        final Artist a = this.context.newObject(Artist.class);
        a.setArtistName("AAA");
        this.context.commitChanges();
        final DeepMergeOperation op = new DeepMergeOperation(this.context1);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Artist a2 = op.merge(a);
                Assert.assertNotNull((Object)a2);
                Assert.assertEquals((long)3L, (long)a2.getPersistenceState());
                Assert.assertEquals((Object)a.getArtistName(), (Object)a2.getArtistName());
            }
        });
    }

    @Test
    public void testDeepMergeModified() {
        final Artist a = this.context.newObject(Artist.class);
        a.setArtistName("AAA");
        this.context.commitChanges();
        final Artist a1 = (Artist)Cayenne.objectForPK(this.context1, a.getObjectId());
        a1.setArtistName("BBB");
        final DeepMergeOperation op = new DeepMergeOperation(this.context1);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Artist a2 = op.merge(a);
                Assert.assertNotNull((Object)a2);
                Assert.assertEquals((long)4L, (long)a2.getPersistenceState());
                Assert.assertSame((Object)a1, (Object)a2);
                Assert.assertEquals((Object)"BBB", (Object)a2.getArtistName());
            }
        });
    }
}

