/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.jira;

import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.junit.Assert;
import org.junit.Test;

public class CAY_743Test {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoad2MapsWithCrossMapInheritance() throws Exception {
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{new ServerModule("cay743/cayenne-domain.xml")});
        try {
            DataDomain domain = (DataDomain)injector.getInstance(DataDomain.class);
            Assert.assertEquals((long)2L, (long)domain.getDataMaps().size());
            DataMap m1 = domain.getDataMap("map1");
            DataMap m2 = domain.getDataMap("map2");
            ObjEntity oe11 = m1.getObjEntity("Entity11");
            ObjEntity oe12 = m1.getObjEntity("Entity12");
            ObjEntity oe21 = m2.getObjEntity("Entity21");
            ObjEntity oe22 = m2.getObjEntity("Entity22");
            ObjEntity oe21Super = oe21.getSuperEntity();
            ObjEntity oe12Super = oe12.getSuperEntity();
            Assert.assertSame((Object)oe12Super, (Object)oe22);
            Assert.assertSame((Object)oe21Super, (Object)oe11);
        }
        finally {
            injector.shutdown();
        }
    }
}

