/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.types.MockEnum;
import org.apache.cayenne.access.types.MockEnumHolder;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.Converter;
import org.apache.cayenne.reflect.ConverterFactory;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.reflect.TstJavaBean;
import org.junit.Assert;
import org.junit.Test;

public class PropertyUtilsTest {
    @Test
    public void testAccessor() {
        Accessor accessor = PropertyUtils.accessor("byteArrayField");
        Assert.assertNotNull((Object)accessor);
        TstJavaBean o1 = this.createBean();
        Assert.assertSame((Object)o1.getByteArrayField(), (Object)accessor.getValue(o1));
        TstJavaBean o2 = new TstJavaBean();
        Assert.assertNull((Object)o2.getByteArrayField());
        accessor.setValue(o2, o1.getByteArrayField());
        Assert.assertNotNull((Object)o2.getByteArrayField());
        Assert.assertSame((Object)o1.getByteArrayField(), (Object)o2.getByteArrayField());
    }

    @Test
    public void testAccessor_Cache() {
        Accessor accessor = PropertyUtils.accessor("p1");
        Assert.assertNotNull((Object)accessor);
        Assert.assertSame((Object)accessor, (Object)PropertyUtils.accessor("p1"));
        Assert.assertSame((Object)accessor, (Object)PropertyUtils.accessor("p1"));
        Assert.assertNotSame((Object)accessor, (Object)PropertyUtils.accessor("p2"));
    }

    @Test
    public void testAccessor_CacheNested() {
        Accessor accessor = PropertyUtils.accessor("p1.p2");
        Assert.assertNotNull((Object)accessor);
        Assert.assertSame((Object)accessor, (Object)PropertyUtils.accessor("p1.p2"));
        Assert.assertNotSame((Object)accessor, (Object)PropertyUtils.accessor("p1"));
        Assert.assertNotSame((Object)accessor, (Object)PropertyUtils.accessor("p2"));
    }

    @Test
    public void testAccessorNested() {
        Accessor accessor = PropertyUtils.accessor("related.byteArrayField");
        Assert.assertNotNull((Object)accessor);
        TstJavaBean o1 = this.createBean();
        o1.setRelated(new TstJavaBean());
        o1.getRelated().setByteArrayField(new byte[]{3, 4, 5});
        Assert.assertSame((Object)o1.getRelated().getByteArrayField(), (Object)accessor.getValue(o1));
        TstJavaBean o2 = new TstJavaBean();
        o2.setRelated(new TstJavaBean());
        byte[] b1 = new byte[]{6, 7, 8};
        accessor.setValue(o2, b1);
        Assert.assertSame((Object)b1, (Object)o2.getRelated().getByteArrayField());
    }

    @Test
    public void testAccessorNested_Null() {
        Accessor accessor = PropertyUtils.accessor("related.byteArrayField");
        Assert.assertNotNull((Object)accessor);
        TstJavaBean o1 = this.createBean();
        Assert.assertNull((Object)accessor.getValue(o1));
    }

    @Test
    public void testGetProperty() {
        TstJavaBean o1 = this.createBean();
        Assert.assertSame((Object)o1.getByteArrayField(), (Object)PropertyUtils.getProperty(o1, "byteArrayField"));
        Assert.assertSame((Object)o1.getIntegerField(), (Object)PropertyUtils.getProperty(o1, "integerField"));
        Assert.assertEquals((Object)new Integer(o1.getIntField()), (Object)PropertyUtils.getProperty(o1, "intField"));
        Assert.assertSame((Object)o1.getNumberField(), (Object)PropertyUtils.getProperty(o1, "numberField"));
        Assert.assertSame((Object)o1.getObjectField(), (Object)PropertyUtils.getProperty(o1, "objectField"));
        Assert.assertSame((Object)o1.getStringField(), (Object)PropertyUtils.getProperty(o1, "stringField"));
        Assert.assertEquals((Object)o1.isBooleanField(), (Object)PropertyUtils.getProperty(o1, "booleanField"));
    }

    @Test
    public void testGetProperty_Nested() {
        TstJavaBean o1 = this.createBean();
        Assert.assertNull((Object)PropertyUtils.getProperty(o1, "related.integerField"));
        TstJavaBean o1related = new TstJavaBean();
        o1related.setIntegerField(44);
        o1.setRelated(o1related);
        Assert.assertEquals((Object)44, (Object)PropertyUtils.getProperty(o1, "related.integerField"));
    }

    @Test
    public void testSetProperty() {
        TstJavaBean o1 = this.createBean();
        TstJavaBean o2 = new TstJavaBean();
        PropertyUtils.setProperty(o2, "byteArrayField", o1.getByteArrayField());
        PropertyUtils.setProperty(o2, "integerField", o1.getIntegerField());
        PropertyUtils.setProperty(o2, "intField", new Integer(o1.getIntField()));
        PropertyUtils.setProperty(o2, "numberField", o1.getNumberField());
        PropertyUtils.setProperty(o2, "objectField", o1.getObjectField());
        PropertyUtils.setProperty(o2, "stringField", o1.getStringField());
        PropertyUtils.setProperty(o2, "booleanField", o1.isBooleanField());
    }

    @Test
    public void testGetPropertyMap() {
        Map<String, Object> o1 = this.createMap();
        Assert.assertSame((Object)o1.get("byteArrayField"), (Object)PropertyUtils.getProperty(o1, "byteArrayField"));
        Assert.assertSame((Object)o1.get("integerField"), (Object)PropertyUtils.getProperty(o1, "integerField"));
        Assert.assertEquals((Object)o1.get("intField"), (Object)PropertyUtils.getProperty(o1, "intField"));
        Assert.assertSame((Object)o1.get("numberField"), (Object)PropertyUtils.getProperty(o1, "numberField"));
        Assert.assertSame((Object)o1.get("objectField"), (Object)PropertyUtils.getProperty(o1, "objectField"));
        Assert.assertSame((Object)o1.get("stringField"), (Object)PropertyUtils.getProperty(o1, "stringField"));
        Assert.assertEquals((Object)o1.get("booleanField"), (Object)PropertyUtils.getProperty(o1, "booleanField"));
    }

    @Test
    public void testSetProperty_Nested() {
        TstJavaBean o1 = this.createBean();
        TstJavaBean o1related = new TstJavaBean();
        o1related.setIntegerField(44);
        o1.setRelated(o1related);
        PropertyUtils.setProperty(o1, "related.integerField", 55);
        Assert.assertEquals((Object)55, (Object)o1related.getIntegerField());
    }

    @Test
    public void testSetProperty_Null() {
        TstJavaBean o1 = this.createBean();
        PropertyUtils.setProperty(o1, "related.integerField", 55);
    }

    @Test
    public void testSetPropertyMap() {
        Map<String, Object> o1 = this.createMap();
        HashMap o2 = new HashMap();
        PropertyUtils.setProperty(o2, "byteArrayField", o1.get("byteArrayField"));
        PropertyUtils.setProperty(o2, "integerField", o1.get("integerField"));
        PropertyUtils.setProperty(o2, "intField", o1.get("intField"));
        PropertyUtils.setProperty(o2, "numberField", o1.get("numberField"));
        PropertyUtils.setProperty(o2, "objectField", o1.get("objectField"));
        PropertyUtils.setProperty(o2, "stringField", o1.get("stringField"));
        PropertyUtils.setProperty(o2, "booleanField", o1.get("booleanField"));
        Assert.assertEquals(o1, o2);
    }

    @Test
    public void testSetConverted() {
        TstJavaBean o1 = new TstJavaBean();
        Object object = new Object();
        PropertyUtils.setProperty(o1, "stringField", object);
        Assert.assertEquals((Object)object.toString(), (Object)o1.getStringField());
        PropertyUtils.setProperty(o1, "integerField", "25");
        Assert.assertEquals((Object)new Integer(25), (Object)o1.getIntegerField());
        PropertyUtils.setProperty(o1, "byteField", "2");
        Assert.assertEquals((long)2L, (long)o1.getByteField());
        PropertyUtils.setProperty(o1, "shortField", "3");
        Assert.assertEquals((long)3L, (long)o1.getShortField());
        PropertyUtils.setProperty(o1, "intField", "28");
        Assert.assertEquals((long)28L, (long)o1.getIntField());
        PropertyUtils.setProperty(o1, "longField", "29");
        Assert.assertEquals((long)29L, (long)o1.getLongField());
        PropertyUtils.setProperty(o1, "floatField", "4.5");
        Assert.assertEquals((float)4.5f, (float)o1.getFloatField(), (float)0.0f);
        PropertyUtils.setProperty(o1, "doubleField", "5.5");
        Assert.assertEquals((double)5.5, (double)o1.getDoubleField(), (double)0.0);
        PropertyUtils.setProperty(o1, "booleanField", "true");
        Assert.assertTrue((boolean)o1.isBooleanField());
        PropertyUtils.setProperty(o1, "booleanField", "false");
        Assert.assertFalse((boolean)o1.isBooleanField());
        PropertyUtils.setProperty(o1, "booleanField", 1);
        Assert.assertTrue((boolean)o1.isBooleanField());
        PropertyUtils.setProperty(o1, "booleanField", 0);
        Assert.assertFalse((boolean)o1.isBooleanField());
        PropertyUtils.setProperty(o1, "booleanField", 1L);
        Assert.assertTrue((boolean)o1.isBooleanField());
        PropertyUtils.setProperty(o1, "booleanField", 0L);
        Assert.assertFalse((boolean)o1.isBooleanField());
        PropertyUtils.setProperty(o1, "dateField", 0L);
        Assert.assertEquals((Object)new Date(0L), (Object)o1.getDateField());
        PropertyUtils.setProperty(o1, "timestampField", 0L);
        Assert.assertEquals((Object)new Timestamp(0L), (Object)o1.getTimestampField());
        PropertyUtils.setProperty(o1, "stringBuilderField", "abc");
        Assert.assertEquals((Object)"abc", (Object)o1.getStringBuilderField().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetConvertedWithCustomConverter() {
        Converter<Date> oldConverter = ConverterFactory.factory.getConverter(Date.class);
        try {
            ConverterFactory.addConverter(Date.class, new Converter<Date>(){

                @Override
                protected Date convert(Object value, Class<Date> type) {
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof Date) {
                        return (Date)value;
                    }
                    if (value instanceof String) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        try {
                            return format.parse((String)value);
                        }
                        catch (ParseException e) {
                            throw new CayenneRuntimeException("Unable to convert '" + value + "' to a Date", (Throwable)e, new Object[0]);
                        }
                    }
                    throw new CayenneRuntimeException("Unable to convert '" + value + "' to a Date", new Object[0]);
                }
            });
            TstJavaBean o1 = new TstJavaBean();
            PropertyUtils.setProperty(o1, "dateField", "2013-08-01");
            GregorianCalendar cal = new GregorianCalendar(2013, 7, 1, 0, 0, 0);
            Assert.assertEquals((Object)cal.getTime(), (Object)o1.getDateField());
        }
        finally {
            ConverterFactory.addConverter(Date.class, oldConverter);
        }
    }

    @Test
    public void testSetNull() {
        TstJavaBean o1 = new TstJavaBean();
        o1.setStringField("xyz");
        PropertyUtils.setProperty(o1, "stringField", null);
        Assert.assertNull((Object)o1.getStringField());
        o1.setBooleanField(true);
        PropertyUtils.setProperty(o1, "booleanField", null);
        Assert.assertEquals((Object)false, (Object)o1.isBooleanField());
        o1.setByteField((byte)2);
        PropertyUtils.setProperty(o1, "byteField", null);
        Assert.assertEquals((long)0L, (long)o1.getByteField());
        o1.setShortField((short)3);
        PropertyUtils.setProperty(o1, "shortField", null);
        Assert.assertEquals((long)0L, (long)o1.getShortField());
        o1.setIntField(99);
        PropertyUtils.setProperty(o1, "intField", null);
        Assert.assertEquals((long)0L, (long)o1.getIntField());
        o1.setLongField(98L);
        PropertyUtils.setProperty(o1, "longField", null);
        Assert.assertEquals((long)0L, (long)o1.getLongField());
        o1.setFloatField(4.5f);
        PropertyUtils.setProperty(o1, "floatField", null);
        Assert.assertEquals((float)0.0f, (float)o1.getFloatField(), (float)0.0f);
        o1.setDoubleField(5.5);
        PropertyUtils.setProperty(o1, "doubleField", null);
        Assert.assertEquals((double)0.0, (double)o1.getDoubleField(), (double)0.0);
    }

    @Test
    public void testSetConvertedEnum() {
        MockEnumHolder o1 = new MockEnumHolder();
        PropertyUtils.setProperty(o1, "mockEnum", "b");
        Assert.assertSame((Object)((Object)MockEnum.b), (Object)((Object)o1.getMockEnum()));
        PropertyUtils.setProperty(o1, "number", "445");
        Assert.assertEquals((long)445L, (long)o1.getNumber());
    }

    protected TstJavaBean createBean() {
        TstJavaBean o1 = new TstJavaBean();
        o1.setByteArrayField(new byte[]{1, 2, 3});
        o1.setIntegerField(new Integer(33));
        o1.setIntField(-44);
        o1.setNumberField(new BigDecimal("11111"));
        o1.setObjectField(new Object());
        o1.setStringField("aaaaa");
        o1.setBooleanField(true);
        return o1;
    }

    protected Map<String, Object> createMap() {
        HashMap<String, Object> o1 = new HashMap<String, Object>();
        o1.put("byteArrayField", new byte[]{1, 2, 3});
        o1.put("integerField", new Integer(33));
        o1.put("intField", new Integer(-44));
        o1.put("numberField", new BigDecimal("11111"));
        o1.put("objectField", new Object());
        o1.put("stringField", "aaaaa");
        o1.put("booleanField", Boolean.TRUE);
        return o1;
    }
}

