/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.Select;

public class SQLSelect<T>
extends IndirectQuery
implements Select<T> {
    private static final long serialVersionUID = -7074293371883740872L;
    protected Class<T> persistentType;
    protected Class<T> scalarType;
    protected String dataMapName;
    protected StringBuilder sqlBuffer;
    protected QueryCacheStrategy cacheStrategy;
    protected String[] cacheGroups;
    protected Map<String, Object> params;
    protected List<Object> positionalParams;
    protected CapsStrategy columnNameCaps;
    protected int limit;
    protected int offset;
    protected int pageSize;
    protected int statementFetchSize;

    public static SQLSelect<DataRow> dataRowQuery(String sql) {
        SQLSelect<DataRow> query = new SQLSelect<DataRow>(sql);
        return query;
    }

    public static SQLSelect<DataRow> dataRowQuery(String dataMapName, String sql) {
        SQLSelect<DataRow> query = new SQLSelect<DataRow>(sql);
        query.dataMapName = dataMapName;
        return query;
    }

    public static <T> SQLSelect<T> query(Class<T> type, String sql) {
        return new SQLSelect<T>(type, sql);
    }

    public static <T> SQLSelect<T> scalarQuery(Class<T> type, String sql) {
        SQLSelect<T> query = new SQLSelect<T>(sql);
        query.scalarType = type;
        return query;
    }

    public static <T> SQLSelect<T> scalarQuery(Class<T> type, String dataMapName, String sql) {
        SQLSelect<T> query = new SQLSelect<T>(sql);
        query.dataMapName = dataMapName;
        query.scalarType = type;
        return query;
    }

    public SQLSelect(String sql) {
        this(null, sql);
    }

    public SQLSelect(Class<T> persistentType, String sql) {
        this.persistentType = persistentType;
        this.sqlBuffer = sql != null ? new StringBuilder(sql) : new StringBuilder();
        this.limit = 0;
        this.offset = 0;
        this.pageSize = 0;
    }

    @Override
    public List<T> select(ObjectContext context) {
        return context.select(this);
    }

    @Override
    public T selectOne(ObjectContext context) {
        return context.selectOne(this);
    }

    @Override
    public T selectFirst(ObjectContext context) {
        return context.selectFirst(this.limit(1));
    }

    @Override
    public void iterate(ObjectContext context, ResultIteratorCallback<T> callback) {
        context.iterate(this, callback);
    }

    @Override
    public ResultIterator<T> iterator(ObjectContext context) {
        return context.iterator(this);
    }

    @Override
    public ResultBatchIterator<T> batchIterator(ObjectContext context, int size) {
        return context.batchIterator(this, size);
    }

    public boolean isFetchingDataRows() {
        return this.persistentType == null;
    }

    public boolean isFetchingScalars() {
        return this.scalarType != null;
    }

    public String getSql() {
        String sql = this.sqlBuffer.toString();
        return sql.length() > 0 ? sql : null;
    }

    public SQLSelect<T> append(String sqlChunk) {
        this.sqlBuffer.append(sqlChunk);
        this.replacementQuery = null;
        return this;
    }

    public SQLSelect<T> params(String name, Object value) {
        this.params(Collections.singletonMap(name, value));
        return this;
    }

    public SQLSelect<T> params(Map<String, ?> parameters) {
        if (this.params == null) {
            this.params = new HashMap(parameters);
        } else {
            Map<String, ?> bareMap = parameters;
            this.params.putAll(bareMap);
        }
        this.replacementQuery = null;
        this.positionalParams = null;
        return this;
    }

    public SQLSelect<T> paramsArray(Object ... params) {
        return this.paramsList(params != null ? Arrays.asList(params) : null);
    }

    public SQLSelect<T> paramsList(List<Object> params) {
        this.params = null;
        this.positionalParams = params;
        return this;
    }

    public Map<String, Object> getParams() {
        return this.params != null ? this.params : Collections.emptyMap();
    }

    public List<Object> getPositionalParams() {
        return this.positionalParams != null ? this.positionalParams : Collections.emptyList();
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        Serializable root;
        if (this.persistentType != null) {
            root = this.persistentType;
        } else if (this.dataMapName != null) {
            DataMap map = resolver.getDataMap(this.dataMapName);
            if (map == null) {
                throw new CayenneRuntimeException("Invalid dataMapName '%s'", this.dataMapName);
            }
            root = map;
        } else {
            root = null;
        }
        SQLTemplate template = new SQLTemplate();
        template.setFetchingDataRows(this.isFetchingDataRows());
        template.setRoot(root);
        template.setDefaultTemplate(this.getSql());
        template.setCacheGroups(this.cacheGroups);
        template.setCacheStrategy(this.cacheStrategy);
        if (this.positionalParams != null) {
            template.setParamsList(this.positionalParams);
        } else {
            template.setParams(this.params);
        }
        template.setColumnNamesCapitalization(this.columnNameCaps);
        template.setFetchLimit(this.limit);
        template.setFetchOffset(this.offset);
        template.setPageSize(this.pageSize);
        template.setStatementFetchSize(this.statementFetchSize);
        if (this.isFetchingScalars()) {
            SQLResult resultMap = new SQLResult();
            resultMap.addColumnResult("x");
            template.setResult(resultMap);
        }
        return template;
    }

    public SQLSelect<T> localCache(String ... cacheGroups) {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE, cacheGroups);
    }

    public SQLSelect<T> sharedCache(String ... cacheGroups) {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE, cacheGroups);
    }

    public QueryCacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    public SQLSelect<T> cacheStrategy(QueryCacheStrategy strategy, String ... cacheGroups) {
        if (this.cacheStrategy != strategy) {
            this.cacheStrategy = strategy;
            this.replacementQuery = null;
        }
        return this.cacheGroups(cacheGroups);
    }

    public String[] getCacheGroups() {
        return this.cacheGroups;
    }

    public SQLSelect<T> cacheGroups(String ... cacheGroups) {
        this.cacheGroups = cacheGroups != null && cacheGroups.length > 0 ? cacheGroups : null;
        this.replacementQuery = null;
        return this;
    }

    public SQLSelect<T> cacheGroups(Collection<String> cacheGroups) {
        if (cacheGroups == null) {
            return this.cacheGroups(new String[]{null});
        }
        String[] array = new String[cacheGroups.size()];
        return this.cacheGroups(cacheGroups.toArray(array));
    }

    public CapsStrategy getColumnNameCaps() {
        return this.columnNameCaps;
    }

    public SQLSelect<T> columnNameCaps(CapsStrategy columnNameCaps) {
        if (this.columnNameCaps != columnNameCaps) {
            this.columnNameCaps = columnNameCaps;
            this.replacementQuery = null;
        }
        return this;
    }

    public SQLSelect<T> upperColumnNames() {
        return this.columnNameCaps(CapsStrategy.UPPER);
    }

    public SQLSelect<T> lowerColumnNames() {
        return this.columnNameCaps(CapsStrategy.LOWER);
    }

    public int getLimit() {
        return this.limit;
    }

    public SQLSelect<T> limit(int fetchLimit) {
        if (this.limit != fetchLimit) {
            this.limit = fetchLimit;
            this.replacementQuery = null;
        }
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public SQLSelect<T> offset(int fetchOffset) {
        if (this.offset != fetchOffset) {
            this.offset = fetchOffset;
            this.replacementQuery = null;
        }
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public SQLSelect<T> pageSize(int pageSize) {
        if (this.pageSize != pageSize) {
            this.pageSize = pageSize;
            this.replacementQuery = null;
        }
        return this;
    }

    public SQLSelect<T> statementFetchSize(int size) {
        if (this.statementFetchSize != size) {
            this.statementFetchSize = size;
            this.replacementQuery = null;
        }
        return this;
    }

    public int getStatementFetchSize() {
        return this.statementFetchSize;
    }
}

