/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import org.apache.cayenne.MockPersistentObject;
import org.apache.cayenne.query.MockQuery;
import org.apache.cayenne.query.RefreshQuery;
import org.junit.Assert;
import org.junit.Test;

public class RefreshQueryTest {
    @Test
    public void testRefreshAllConstructor() {
        RefreshQuery q = new RefreshQuery();
        Assert.assertNull(q.getObjects());
        Assert.assertNull((Object)q.getQuery());
        Assert.assertNull((Object)q.getGroupKeys());
        Assert.assertTrue((boolean)q.isRefreshAll());
    }

    @Test
    public void testCollectionConstructor() {
        ArrayList<Object> c = new ArrayList<Object>();
        c.add(new Object());
        c.add(new Object());
        RefreshQuery q = new RefreshQuery(c);
        Assert.assertSame(c, q.getObjects());
        Assert.assertNull((Object)q.getQuery());
        Assert.assertNull((Object)q.getGroupKeys());
        Assert.assertFalse((boolean)q.isRefreshAll());
    }

    @Test
    public void testObjectConstructor() {
        MockPersistentObject p = new MockPersistentObject();
        RefreshQuery q = new RefreshQuery(p);
        Assert.assertNotNull(q.getObjects());
        Assert.assertEquals((long)1L, (long)q.getObjects().size());
        Assert.assertSame((Object)p, q.getObjects().iterator().next());
        Assert.assertNull((Object)q.getQuery());
        Assert.assertNull((Object)q.getGroupKeys());
        Assert.assertFalse((boolean)q.isRefreshAll());
    }

    @Test
    public void testQueryConstructor() {
        MockQuery query = new MockQuery();
        RefreshQuery q = new RefreshQuery(query);
        Assert.assertNull(q.getObjects());
        Assert.assertNotNull((Object)q.getQuery());
        Assert.assertNotSame((String)"query must be wrapped", (Object)query, (Object)q.getQuery());
        Assert.assertNull((Object)q.getGroupKeys());
        Assert.assertFalse((boolean)q.isRefreshAll());
    }

    @Test
    public void testGroupKeysConstructor() {
        String[] groupKeys = new String[]{"a", "b"};
        RefreshQuery q = new RefreshQuery(groupKeys);
        Assert.assertNull(q.getObjects());
        Assert.assertNull((Object)q.getQuery());
        Assert.assertSame((Object)groupKeys, (Object)q.getGroupKeys());
    }
}

