/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge.builders;

import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.builders.DbAttributeBuilder;
import org.apache.cayenne.merge.builders.DefaultBuilder;
import org.apache.commons.lang.StringUtils;

public class DbEntityBuilder
extends DefaultBuilder<DbEntity> {
    public DbEntityBuilder() {
        super(new DbEntity());
    }

    public DbEntityBuilder name() {
        return this.name(this.getRandomJavaName());
    }

    public DbEntityBuilder name(String name) {
        ((DbEntity)this.obj).setName(name);
        return this;
    }

    public DbEntityBuilder attributes(DbAttribute ... attributes) {
        for (DbAttribute attribute : attributes) {
            ((DbEntity)this.obj).addAttribute(attribute);
        }
        return this;
    }

    public DbEntityBuilder attributes(DbAttributeBuilder ... attributes) {
        for (DbAttributeBuilder attribute : attributes) {
            ((DbEntity)this.obj).addAttribute(attribute.build());
        }
        return this;
    }

    public DbEntityBuilder attributes(int numberUpTo) {
        for (int i = 0; i < numberUpTo; ++i) {
            try {
                ((DbEntity)this.obj).addAttribute(new DbAttributeBuilder().random());
                continue;
            }
            catch (IllegalArgumentException e) {
                --i;
            }
        }
        return this;
    }

    @Override
    public DbEntity build() {
        if (((DbEntity)this.obj).getName() == null) {
            ((DbEntity)this.obj).setName(StringUtils.capitalize((String)this.getRandomJavaName()));
        }
        return (DbEntity)this.obj;
    }

    @Override
    public DbEntity random() {
        if (this.dataFactory.chance(99)) {
            this.attributes(this.dataFactory.getNumberUpTo(20));
        }
        return this.build();
    }
}

