/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map.naming;

import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.naming.DefaultUniqueNameGenerator;
import org.apache.cayenne.map.naming.NameCheckers;
import org.apache.cayenne.query.SelectQuery;
import org.junit.Assert;
import org.junit.Test;

public class NameCheckersTest {
    @Test
    public void testObjEntityAttributes() throws Exception {
        NameCheckers maker = NameCheckers.objAttribute;
        ObjEntity namingContainer = new ObjEntity();
        String baseName = maker.baseName();
        String name = DefaultUniqueNameGenerator.generate(maker, namingContainer);
        Assert.assertEquals((Object)baseName, (Object)name);
        namingContainer.addAttribute(new ObjAttribute(name));
        name = DefaultUniqueNameGenerator.generate(maker, namingContainer);
        Assert.assertEquals((Object)(baseName + "1"), (Object)name);
        namingContainer.addAttribute(new ObjAttribute(name));
        name = DefaultUniqueNameGenerator.generate(maker, namingContainer);
        Assert.assertEquals((Object)(baseName + "2"), (Object)name);
        namingContainer.addAttribute(new ObjAttribute(name));
        name = DefaultUniqueNameGenerator.generate(maker, namingContainer);
        Assert.assertEquals((Object)(baseName + "3"), (Object)name);
        namingContainer.addAttribute(new ObjAttribute(name));
        maker = NameCheckers.objRelationship;
        baseName = maker.baseName();
        name = DefaultUniqueNameGenerator.generate(maker, namingContainer);
        Assert.assertEquals((Object)baseName, (Object)name);
        namingContainer.addRelationship(new ObjRelationship(name));
        name = DefaultUniqueNameGenerator.generate(maker, namingContainer);
        Assert.assertEquals((Object)(baseName + "1"), (Object)name);
        namingContainer.addRelationship(new ObjRelationship(name));
        maker = NameCheckers.objCallbackMethod;
        baseName = maker.baseName();
        name = DefaultUniqueNameGenerator.generate(maker, namingContainer);
        Assert.assertEquals((Object)baseName, (Object)name);
        namingContainer.addRelationship(new ObjRelationship(name));
    }

    @Test
    public void testEntity() {
        DataMap map = new DataMap();
        map.addDbEntity(new DbEntity("name"));
        this.checkNameAndOther(map, NameCheckers.dbEntity, "name");
        map.addObjEntity(new ObjEntity("name"));
        this.checkNameAndOther(map, NameCheckers.objEntity, "name");
        map.addProcedure(new Procedure("name"));
        this.checkNameAndOther(map, NameCheckers.procedure, "name");
        SelectQuery query = new SelectQuery("name");
        query.setName("name");
        map.addQuery(query);
        this.checkNameAndOther(map, NameCheckers.query, "name");
    }

    @Test
    public void testProject() throws Exception {
        Assert.assertFalse((boolean)NameCheckers.dataChannelDescriptor.isNameInUse(null, null));
    }

    @Test
    public void testDbEntity() throws Exception {
        DbEntity dbEntity = new DbEntity();
        dbEntity.addRelationship(new DbRelationship("name"));
        this.checkNameAndOther(dbEntity, NameCheckers.dbRelationship, "name");
    }

    @Test
    public void testProcedureAttr() throws Exception {
        Procedure procedure = new Procedure();
        procedure.addCallParameter(new ProcedureParameter("name"));
        this.checkNameAndOther(procedure, NameCheckers.procedureParameter, "name");
    }

    @Test
    public void testEmbeddableAttr() throws Exception {
        Embeddable embeddable = new Embeddable();
        embeddable.addAttribute(new EmbeddableAttribute("name"));
        this.checkNameAndOther(embeddable, NameCheckers.embeddableAttribute, "name");
    }

    @Test
    public void testDatanode() throws Exception {
        DataChannelDescriptor descriptor = new DataChannelDescriptor();
        descriptor.getDataMaps().add(new DataMap("name"));
        this.checkNameAndOther(descriptor, NameCheckers.dataMap, "name");
        descriptor.getNodeDescriptors().add(new DataNodeDescriptor("name"));
        this.checkNameAndOther(descriptor, NameCheckers.dataNodeDescriptor, "name");
    }

    @Test
    public void testDataMap() throws Exception {
        DataDomain dataDomain = new DataDomain("name");
        dataDomain.addDataMap(new DataMap("name"));
        this.checkNameAndOther(dataDomain, NameCheckers.dataMap, "name");
        Assert.assertFalse((boolean)NameCheckers.dataMap.isNameInUse(null, "name"));
        Assert.assertFalse((boolean)NameCheckers.dataMap.isNameInUse(1, "name"));
    }

    private void checkNameAndOther(Object namingContainer, NameCheckers maker, String newName) {
        Assert.assertTrue((boolean)maker.isNameInUse(namingContainer, newName));
        Assert.assertEquals((Object)(newName + "1"), (Object)DefaultUniqueNameGenerator.generate(maker, namingContainer, newName));
        Assert.assertEquals((Object)("other" + newName), (Object)DefaultUniqueNameGenerator.generate(maker, namingContainer, "other" + newName));
    }

    @Test
    public void testOverlappingAttributeAndCallbackNames() throws Exception {
        ObjEntity namingContainer = new ObjEntity();
        namingContainer.addAttribute(new ObjAttribute("myName"));
        Assert.assertEquals((Object)"getMyName1", (Object)DefaultUniqueNameGenerator.generate(NameCheckers.objCallbackMethod, namingContainer, "getMyName"));
        namingContainer.getCallbackMap().getPostAdd().addCallbackMethod("getSecondName");
        Assert.assertEquals((Object)"SecondName1", (Object)DefaultUniqueNameGenerator.generate(NameCheckers.objAttribute, namingContainer, "SecondName"));
        Assert.assertEquals((Object)"secondName1", (Object)DefaultUniqueNameGenerator.generate(NameCheckers.objAttribute, namingContainer, "secondName"));
        Assert.assertEquals((Object)"SecondName1", (Object)DefaultUniqueNameGenerator.generate(NameCheckers.objRelationship, namingContainer, "SecondName"));
        Assert.assertEquals((Object)"secondName1", (Object)DefaultUniqueNameGenerator.generate(NameCheckers.objRelationship, namingContainer, "secondName"));
    }

    @Test
    public void testAttributeDifferentInFirstLetterCases() throws Exception {
        ObjEntity namingContainer = new ObjEntity();
        namingContainer.addAttribute(new ObjAttribute("myName"));
        Assert.assertTrue((boolean)NameCheckers.objAttribute.isNameInUse(namingContainer, "myName"));
        Assert.assertFalse((boolean)NameCheckers.objAttribute.isNameInUse(namingContainer, "MyName"));
        namingContainer.getCallbackMap().getPostAdd().addCallbackMethod("getSecondName");
        Assert.assertEquals((Object)"SecondName1", (Object)DefaultUniqueNameGenerator.generate(NameCheckers.objAttribute, namingContainer, "SecondName"));
        Assert.assertEquals((Object)"secondName1", (Object)DefaultUniqueNameGenerator.generate(NameCheckers.objAttribute, namingContainer, "secondName"));
    }

    @Test
    public void testEmbeddable() {
        DataMap map = new DataMap();
        map.addEmbeddable(new Embeddable("name"));
        Assert.assertTrue((boolean)NameCheckers.embeddable.isNameInUse(map, "name"));
        Assert.assertEquals((Object)"name1", (Object)DefaultUniqueNameGenerator.generate(NameCheckers.embeddable, map, "name"));
        Assert.assertFalse((boolean)NameCheckers.embeddable.isNameInUse(map, "other-name"));
        map.setDefaultPackage("package");
        Assert.assertFalse((boolean)NameCheckers.embeddable.isNameInUse(map, "name"));
        Assert.assertEquals((Object)"package.name", (Object)DefaultUniqueNameGenerator.generate(NameCheckers.embeddable, map, "name"));
        map.addEmbeddable(new Embeddable("package.name"));
        Assert.assertTrue((boolean)NameCheckers.embeddable.isNameInUse(map, "name"));
        Assert.assertEquals((Object)"package.name1", (Object)DefaultUniqueNameGenerator.generate(NameCheckers.embeddable, map, "name"));
        Assert.assertFalse((boolean)NameCheckers.embeddable.isNameInUse(map, "other-name"));
    }
}

