/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.SelectQueryBuilder;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.junit.Assert;
import org.junit.Test;

public class SelectQueryBuilderTest {
    @Test
    public void testGetQueryType() throws Exception {
        MockupRootQueryBuilder builder = new MockupRootQueryBuilder();
        Assert.assertTrue((boolean)(builder.getQuery() instanceof SelectQuery));
    }

    @Test
    public void testGetQueryName() throws Exception {
        MockupRootQueryBuilder builder = new MockupRootQueryBuilder();
        builder.setName("xyz");
        Assert.assertEquals((Object)"xyz", (Object)builder.getQuery().getName());
    }

    @Test
    public void testGetQueryRoot() throws Exception {
        DataMap map = new DataMap();
        ObjEntity entity = new ObjEntity("A");
        map.addObjEntity(entity);
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.setRoot(map, "obj-entity", "A");
        Assert.assertTrue((boolean)(builder.getQuery() instanceof SelectQuery));
        Assert.assertSame((Object)entity, (Object)((SelectQuery)builder.getQuery()).getRoot());
    }

    @Test
    public void testGetQueryQualifier() throws Exception {
        MockupRootQueryBuilder builder = new MockupRootQueryBuilder();
        builder.setQualifier("abc = 5");
        SelectQuery query = (SelectQuery)builder.getQuery();
        Assert.assertEquals((Object)Expression.fromString("abc = 5"), (Object)query.getQualifier());
    }

    @Test
    public void testGetQueryProperties() throws Exception {
        MockupRootQueryBuilder builder = new MockupRootQueryBuilder();
        builder.addProperty("cayenne.GenericSelectQuery.fetchLimit", "5");
        builder.addProperty("cayenne.GenericSelectQuery.statementFetchSize", "6");
        Query query = builder.getQuery();
        Assert.assertTrue((boolean)(query instanceof SelectQuery));
        Assert.assertEquals((long)5L, (long)((SelectQuery)query).getFetchLimit());
        Assert.assertEquals((long)6L, (long)((SelectQuery)query).getStatementFetchSize());
    }

    class MockupRootQueryBuilder
    extends SelectQueryBuilder {
        MockupRootQueryBuilder() {
        }

        @Override
        public Object getRoot() {
            return "FakeRoot";
        }
    }
}

