/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.util.TstBean;
import org.junit.Assert;
import org.junit.Test;

public class ASTObjPathTest {
    @Test
    public void testToString() {
        Assert.assertEquals((Object)"x.y", (Object)new ASTObjPath("x.y").toString());
    }

    @Test
    public void testToEJBQL() {
        Assert.assertEquals((Object)"r.x.y", (Object)new ASTObjPath("x.y").toEJBQL("r"));
    }

    @Test
    public void testToEJBQL_OuterJoin() {
        Assert.assertEquals((Object)"r.x+.y", (Object)new ASTObjPath("x+.y").toEJBQL("r"));
    }

    @Test
    public void testAppendAsString() throws IOException {
        StringBuilder buffer = new StringBuilder();
        new ASTObjPath("x.y").appendAsString(buffer);
        Assert.assertEquals((Object)"x.y", (Object)buffer.toString());
    }

    @Test
    public void testEvaluate_DataObject() {
        ASTObjPath node = new ASTObjPath("artistName");
        Artist a1 = new Artist();
        a1.setArtistName("abc");
        Assert.assertEquals((Object)"abc", (Object)node.evaluate(a1));
        Artist a2 = new Artist();
        a2.setArtistName("123");
        Assert.assertEquals((Object)"123", (Object)node.evaluate(a2));
    }

    @Test
    public void testEvaluate_JavaBean() {
        ASTObjPath node = new ASTObjPath("property2");
        TstBean b1 = new TstBean();
        b1.setProperty2(1);
        Assert.assertEquals((Object)new Integer(1), (Object)node.evaluate(b1));
        TstBean b2 = new TstBean();
        b2.setProperty2(-3);
        Assert.assertEquals((Object)new Integer(-3), (Object)node.evaluate(b2));
    }
}

