/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import org.apache.cayenne.exp.parser.ASTLike;
import org.apache.cayenne.exp.parser.ASTNotLike;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Test;

public class ASTLikeTest {
    @Test
    public void testToEJBQL_likeEscape() throws IOException {
        ASTLike like = new ASTLike(new ASTObjPath("mainName"), "|%|%?|_title|%", '|');
        Assert.assertEquals((Object)"x.mainName like '|%|%?|_title|%' escape '|'", (Object)like.toEJBQL("x"));
    }

    @Test
    public void testEvaluate_MultiCharMatch() {
        ASTLike like = new ASTLike(new ASTObjPath("artistName"), "abc%d");
        ASTNotLike notLike = new ASTNotLike(new ASTObjPath("artistName"), "abc%d");
        Artist noMatch = new Artist();
        noMatch.setArtistName("dabc");
        Assert.assertFalse((boolean)like.match(noMatch));
        Assert.assertTrue((boolean)notLike.match(noMatch));
        Artist match1 = new Artist();
        match1.setArtistName("abc123d");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match1));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match1));
        Artist match2 = new Artist();
        match2.setArtistName("abcd");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match2));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match2));
    }

    @Test
    public void testEvaluate_SingleCharMatch() {
        ASTLike like = new ASTLike(new ASTObjPath("artistName"), "abc?d");
        ASTNotLike notLike = new ASTNotLike(new ASTObjPath("artistName"), "abc?d");
        Artist noMatch1 = new Artist();
        noMatch1.setArtistName("dabc");
        Assert.assertFalse((boolean)like.match(noMatch1));
        Assert.assertTrue((boolean)notLike.match(noMatch1));
        Artist noMatch2 = new Artist();
        noMatch2.setArtistName("abc123d");
        Assert.assertFalse((String)("Failed: " + like), (boolean)like.match(noMatch2));
        Assert.assertTrue((String)("Failed: " + notLike), (boolean)notLike.match(noMatch2));
        Artist match = new Artist();
        match.setArtistName("abcXd");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match));
        Assert.assertFalse((String)("Failed: " + notLike), (boolean)notLike.match(match));
    }

    @Test
    public void testEvaluate_NotSoSpecialChars() {
        ASTLike like = new ASTLike(new ASTObjPath("artistName"), "/./");
        Artist noMatch1 = new Artist();
        noMatch1.setArtistName("/a/");
        Assert.assertFalse((boolean)like.match(noMatch1));
        Artist match = new Artist();
        match.setArtistName("/./");
        Assert.assertTrue((String)("Failed: " + like), (boolean)like.match(match));
    }
}

