/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.hsqldb;

import org.apache.cayenne.dba.hsqldb.HSQLDBAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class HSQLDBAdapterIT
extends ServerCase {
    @Inject
    private AdhocObjectFactory objectFactory;

    @Test
    public void testCreateTableIgnoresDoublePrecision() {
        HSQLDBAdapter adapter = (HSQLDBAdapter)this.objectFactory.newInstance(HSQLDBAdapter.class, HSQLDBAdapter.class.getName());
        DbEntity e = new DbEntity("Test");
        DbAttribute dblPrec = new DbAttribute("dbl1");
        dblPrec.setType(8);
        dblPrec.setMaxLength(22);
        e.addAttribute(dblPrec);
        String sql = adapter.createTable(e);
        Assert.assertTrue((sql.indexOf("DOUBLE") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)sql.indexOf("DOUBLE(22)"));
    }

    @Test
    public void testCreateTableAddsCachedKeyword() {
        HSQLDBAdapter adapter = (HSQLDBAdapter)this.objectFactory.newInstance(HSQLDBAdapter.class, HSQLDBAdapter.class.getName());
        DbEntity e = new DbEntity("Test");
        DbAttribute dblPrec = new DbAttribute("dbl1");
        dblPrec.setType(4);
        e.addAttribute(dblPrec);
        String sql = adapter.createTable(e);
        Assert.assertEquals((long)0L, (long)sql.indexOf("CREATE CACHED TABLE"));
    }
}

