/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.TranslationCase;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.select.OrderingTranslator;
import org.apache.cayenne.access.translator.select.TstQueryAssembler;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class OrderingTranslatorIT
extends ServerCase {
    @Inject
    private DataNode node;
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;

    @Test
    public void testDoTranslation1() throws Exception {
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addOrdering("artistName", SortOrder.ASCENDING);
        TstQueryAssembler qa = new TstQueryAssembler(q, this.node.getAdapter(), this.node.getEntityResolver());
        TranslationCase tstCase = new TranslationCase("Artist", null, "ta.ARTIST_NAME");
        StringBuilder out = new StringBuilder();
        new OrderingTranslator(qa).appendPart(out);
        Assert.assertTrue((out.length() > 0 ? 1 : 0) != 0);
        tstCase.assertTranslatedWell(out.toString());
    }

    @Test
    public void testDoTranslation2() throws Exception {
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addOrdering("artistName", SortOrder.DESCENDING);
        TstQueryAssembler qa = new TstQueryAssembler(q, this.node.getAdapter(), this.node.getEntityResolver());
        TranslationCase tstCase = new TranslationCase("Artist", null, "ta.ARTIST_NAME DESC");
        StringBuilder out = new StringBuilder();
        new OrderingTranslator(qa).appendPart(out);
        Assert.assertTrue((out.length() > 0 ? 1 : 0) != 0);
        tstCase.assertTranslatedWell(out.toString());
    }

    @Test
    public void testDoTranslation4() throws Exception {
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addOrdering("artistName", SortOrder.ASCENDING_INSENSITIVE);
        TstQueryAssembler qa = new TstQueryAssembler(q, this.node.getAdapter(), this.node.getEntityResolver());
        TranslationCase tstCase = new TranslationCase("Artist", null, "UPPER(ta.ARTIST_NAME)");
        StringBuilder out = new StringBuilder();
        new OrderingTranslator(qa).appendPart(out);
        Assert.assertTrue((out.length() > 0 ? 1 : 0) != 0);
        String orderBySql = out.toString();
        Assert.assertTrue((boolean)orderBySql.contains("UPPER("));
        tstCase.assertTranslatedWell(orderBySql);
    }

    @Test
    public void testDoTranslation5() throws Exception {
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addOrdering("artistName", SortOrder.DESCENDING_INSENSITIVE);
        q.addOrdering("paintingArray.estimatedPrice", SortOrder.ASCENDING);
        TstQueryAssembler qa = new TstQueryAssembler(q, this.node.getAdapter(), this.node.getEntityResolver());
        TranslationCase tstCase = new TranslationCase("Artist", null, "UPPER(ta.ARTIST_NAME) DESC, ta.ESTIMATED_PRICE");
        StringBuilder out = new StringBuilder();
        new OrderingTranslator(qa).appendPart(out);
        Assert.assertTrue((out.length() > 0 ? 1 : 0) != 0);
        String orderBySql = out.toString();
        int indexOfUpper = orderBySql.indexOf("UPPER(");
        Assert.assertTrue((indexOfUpper != -1 ? 1 : 0) != 0);
        Assert.assertTrue((orderBySql.indexOf("UPPER(", indexOfUpper + 1) == -1 ? 1 : 0) != 0);
        tstCase.assertTranslatedWell(orderBySql);
    }

    @Test
    public void testDoTranslation6() throws Exception {
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addOrdering("artistName", SortOrder.ASCENDING_INSENSITIVE);
        q.addOrdering("paintingArray.estimatedPrice", SortOrder.ASCENDING_INSENSITIVE);
        TstQueryAssembler qa = new TstQueryAssembler(q, this.node.getAdapter(), this.node.getEntityResolver());
        TranslationCase tstCase = new TranslationCase("Artist", null, "UPPER(ta.ARTIST_NAME), UPPER(ta.ESTIMATED_PRICE)");
        StringBuilder out = new StringBuilder();
        new OrderingTranslator(qa).appendPart(out);
        Assert.assertTrue((out.length() > 0 ? 1 : 0) != 0);
        String orderBySql = out.toString();
        int indexOfUpper = orderBySql.indexOf("UPPER(");
        Assert.assertTrue((indexOfUpper != -1 ? 1 : 0) != 0);
        Assert.assertTrue((orderBySql.indexOf("UPPER(", indexOfUpper + 1) != -1 ? 1 : 0) != 0);
        tstCase.assertTranslatedWell(orderBySql);
    }

    @Test
    public void testDoTranslation3() throws Exception {
        SelectQuery<Artist> q = SelectQuery.query(Artist.class);
        q.addOrdering("artistName", SortOrder.DESCENDING);
        q.addOrdering("paintingArray.estimatedPrice", SortOrder.ASCENDING);
        TstQueryAssembler qa = new TstQueryAssembler(q, this.node.getAdapter(), this.node.getEntityResolver());
        TranslationCase tstCase = new TranslationCase("Artist", null, "ta.ARTIST_NAME DESC, ta.ESTIMATED_PRICE");
        StringBuilder out = new StringBuilder();
        new OrderingTranslator(qa).appendPart(out);
        Assert.assertTrue((out.length() > 0 ? 1 : 0) != 0);
        String orderBySql = out.toString();
        tstCase.assertTranslatedWell(orderBySql);
    }
}

