/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch;

import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.translator.batch.BatchTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.BatchQueryRow;

public abstract class DefaultBatchTranslator
implements BatchTranslator {
    protected BatchQuery query;
    protected DbAdapter adapter;
    protected String trimFunction;
    protected boolean translated;
    protected String sql;
    protected ParameterBinding[] bindings;

    public DefaultBatchTranslator(BatchQuery query, DbAdapter adapter, String trimFunction) {
        this.query = query;
        this.adapter = adapter;
        this.trimFunction = trimFunction;
    }

    protected void ensureTranslated() {
        if (!this.translated) {
            this.sql = this.createSql();
            this.bindings = this.createBindings();
            this.translated = true;
        }
    }

    @Override
    public String getSql() {
        this.ensureTranslated();
        return this.sql;
    }

    @Override
    public ParameterBinding[] getBindings() {
        this.ensureTranslated();
        return this.bindings;
    }

    @Override
    public ParameterBinding[] updateBindings(BatchQueryRow row) {
        this.ensureTranslated();
        return this.doUpdateBindings(row);
    }

    protected abstract String createSql();

    protected abstract ParameterBinding[] createBindings();

    protected abstract ParameterBinding[] doUpdateBindings(BatchQueryRow var1);

    protected void appendDbAttribute(StringBuilder buf, DbAttribute dbAttribute) {
        boolean trim;
        boolean bl = trim = dbAttribute.getType() == 1 && this.trimFunction != null;
        if (trim) {
            buf.append(this.trimFunction).append('(');
        }
        QuotingStrategy strategy = this.adapter.getQuotingStrategy();
        buf.append(strategy.quotedName(dbAttribute));
        if (trim) {
            buf.append(')');
        }
    }
}

