/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.lang.reflect.Array;
import org.apache.cayenne.MockSerializable;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.misc_types.ArraysEntity;
import org.apache.cayenne.testdo.misc_types.CharacterEntity;
import org.apache.cayenne.testdo.misc_types.SerializableEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-misc-types.xml")
public class MiscTypesIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private UnitDbAdapter accessStackAdapter;

    @Test
    public void testSerializable() throws Exception {
        if (!this.accessStackAdapter.supportsLobs()) {
            return;
        }
        SerializableEntity test = this.context.newObject(SerializableEntity.class);
        MockSerializable i = new MockSerializable("abc");
        test.setSerializableField(i);
        this.context.commitChanges();
        SelectQuery<SerializableEntity> q = new SelectQuery<SerializableEntity>(SerializableEntity.class);
        SerializableEntity testRead = (SerializableEntity)this.context.performQuery(q).get(0);
        Assert.assertNotNull((Object)testRead.getSerializableField());
        Assert.assertEquals((Object)i.getName(), (Object)testRead.getSerializableField().getName());
        test.setSerializableField(null);
        this.context.commitChanges();
    }

    @Test
    public void testByteArray() {
        ArraysEntity test = this.context.newObject(ArraysEntity.class);
        byte[] a = new byte[]{1, 2, 3};
        test.setByteArray(a);
        this.context.commitChanges();
        SelectQuery<ArraysEntity> q = new SelectQuery<ArraysEntity>(ArraysEntity.class);
        ArraysEntity testRead = (ArraysEntity)this.context.performQuery(q).get(0);
        Assert.assertNotNull((Object)testRead.getByteArray());
        this.assertArraysEqual(a, testRead.getByteArray());
        test.setByteArray(null);
        this.context.commitChanges();
    }

    @Test
    public void testCharArray() {
        ArraysEntity test = this.context.newObject(ArraysEntity.class);
        char[] a = new char[]{'x', 'y', 'z'};
        test.setCharArray(a);
        this.context.commitChanges();
        SelectQuery<ArraysEntity> q = new SelectQuery<ArraysEntity>(ArraysEntity.class);
        ArraysEntity testRead = (ArraysEntity)this.context.performQuery(q).get(0);
        Assert.assertNotNull((Object)testRead.getCharArray());
        this.assertArraysEqual(a, testRead.getCharArray());
        test.setCharArray(null);
        this.context.commitChanges();
    }

    @Test
    public void testCharacterArray() {
        ArraysEntity test = this.context.newObject(ArraysEntity.class);
        Character[] a = new Character[]{new Character('x'), new Character('y'), new Character('z')};
        test.setCharWrapperArray(a);
        this.context.commitChanges();
        SelectQuery<ArraysEntity> q = new SelectQuery<ArraysEntity>(ArraysEntity.class);
        ArraysEntity testRead = (ArraysEntity)this.context.performQuery(q).get(0);
        Assert.assertNotNull((Object)testRead.getCharWrapperArray());
        this.assertArraysEqual(a, testRead.getCharWrapperArray());
        test.setCharWrapperArray(null);
        this.context.commitChanges();
    }

    @Test
    public void testCharacter() {
        CharacterEntity test = this.context.newObject(CharacterEntity.class);
        test.setCharacterField(new Character('c'));
        this.context.commitChanges();
        SelectQuery<CharacterEntity> q = new SelectQuery<CharacterEntity>(CharacterEntity.class);
        CharacterEntity testRead = (CharacterEntity)this.context.performQuery(q).get(0);
        Assert.assertNotNull((Object)testRead.getCharacterField());
        Assert.assertEquals((Object)new Character('c'), (Object)testRead.getCharacterField());
        test.setCharacterField(null);
        this.context.commitChanges();
    }

    @Test
    public void testByteWrapperArray() {
        ArraysEntity test = this.context.newObject(ArraysEntity.class);
        Byte[] a = new Byte[]{new Byte(1), new Byte(2), new Byte(3)};
        test.setByteWrapperArray(a);
        this.context.commitChanges();
        SelectQuery<ArraysEntity> q = new SelectQuery<ArraysEntity>(ArraysEntity.class);
        ArraysEntity testRead = (ArraysEntity)this.context.performQuery(q).get(0);
        Assert.assertNotNull((Object)testRead.getByteWrapperArray());
        this.assertArraysEqual(a, testRead.getByteWrapperArray());
        test.setByteWrapperArray(null);
        this.context.commitChanges();
    }

    private void assertArraysEqual(Object a1, Object a2) {
        if (a1 == null && a2 == null) {
            return;
        }
        if (a1 == null && a2 != null) {
            Assert.fail((String)"First array is null");
        }
        if (a2 == null && a1 != null) {
            Assert.fail((String)"Second array is null");
        }
        Assert.assertEquals((long)Array.getLength(a1), (long)Array.getLength(a2));
        for (int i = 0; i < Array.getLength(a1); ++i) {
            Assert.assertEquals((String)("Difference at index " + i), (Object)Array.get(a1, i), (Object)Array.get(a2, i));
        }
    }
}

