/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cayenne.access.DbLoaderDelegate;
import org.apache.cayenne.access.loader.DbAttributesPerSchemaLoader;
import org.apache.cayenne.access.loader.DbLoaderConfiguration;
import org.apache.cayenne.access.loader.DbTableLoader;
import org.apache.cayenne.access.loader.DefaultDbLoaderDelegate;
import org.apache.cayenne.access.loader.ManyToManyCandidateEntity;
import org.apache.cayenne.access.loader.filters.CatalogFilter;
import org.apache.cayenne.access.loader.filters.FiltersConfig;
import org.apache.cayenne.access.loader.filters.PatternFilter;
import org.apache.cayenne.access.loader.filters.SchemaFilter;
import org.apache.cayenne.access.loader.filters.TableFilter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DbRelationshipDetected;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.naming.DefaultUniqueNameGenerator;
import org.apache.cayenne.map.naming.ExportedKey;
import org.apache.cayenne.map.naming.LegacyNameGenerator;
import org.apache.cayenne.map.naming.NameCheckers;
import org.apache.cayenne.map.naming.ObjectNameGenerator;
import org.apache.cayenne.util.EntityMergeSupport;
import org.apache.cayenne.util.EqualsBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbLoader {
    private static final Log LOGGER = LogFactory.getLog(DbLoader.class);
    public static final String WILDCARD = "%";
    public static final String WILDCARD_PATTERN = ".*";
    private final Connection connection;
    private final DbAdapter adapter;
    private final DbLoaderDelegate delegate;
    private boolean creatingMeaningfulPK;
    private DatabaseMetaData metaData;
    private ObjectNameGenerator nameGenerator;

    public DbLoader(Connection connection, DbAdapter adapter, DbLoaderDelegate delegate) {
        this(connection, adapter, delegate, new LegacyNameGenerator());
    }

    public DbLoader(Connection connection, DbAdapter adapter, DbLoaderDelegate delegate, ObjectNameGenerator strategy) {
        this.adapter = adapter;
        this.connection = connection;
        this.delegate = delegate == null ? new DefaultDbLoaderDelegate() : delegate;
        this.setNameGenerator(strategy);
    }

    private DatabaseMetaData getMetaData() throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.connection.getMetaData();
        }
        return this.metaData;
    }

    public void setCreatingMeaningfulPK(boolean creatingMeaningfulPK) {
        this.creatingMeaningfulPK = creatingMeaningfulPK;
    }

    public boolean isCreatingMeaningfulPK() {
        return this.creatingMeaningfulPK;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public List<String> getCatalogs() throws SQLException {
        try (ResultSet rs = this.getMetaData().getCatalogs();){
            List<String> list = DbLoader.getStrings(rs);
            return list;
        }
    }

    public List<String> getSchemas() throws SQLException {
        try (ResultSet rs = this.getMetaData().getSchemas();){
            List<String> list = DbLoader.getStrings(rs);
            return list;
        }
    }

    private static List<String> getStrings(ResultSet rs) throws SQLException {
        ArrayList<String> strings = new ArrayList<String>();
        while (rs.next()) {
            strings.add(rs.getString(1));
        }
        return strings;
    }

    public List<String> getTableTypes() throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        try (ResultSet rs = this.getMetaData().getTableTypes();){
            while (rs.next()) {
                types.add(rs.getString("TABLE_TYPE").trim());
            }
        }
        return types;
    }

    public Collection<ObjEntity> loadObjEntities(DataMap map, DbLoaderConfiguration config, Collection<DbEntity> entities) {
        Collection<ObjEntity> loadedEntities = DbLoader.loadObjEntities(map, config, entities, this.nameGenerator);
        this.createEntityMerger(map).synchronizeWithDbEntities(loadedEntities);
        return loadedEntities;
    }

    public static Collection<ObjEntity> loadObjEntities(DataMap map, DbLoaderConfiguration config, Collection<DbEntity> entities, ObjectNameGenerator nameGenerator) {
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ObjEntity> loadedEntities = new ArrayList<ObjEntity>(entities.size());
        for (DbEntity dbEntity : entities) {
            Collection<ObjEntity> existing = map.getMappedEntities(dbEntity);
            if (!existing.isEmpty()) {
                loadedEntities.addAll(existing);
                continue;
            }
            String objEntityName = DefaultUniqueNameGenerator.generate(NameCheckers.objEntity, map, nameGenerator.createObjEntityName(dbEntity));
            ObjEntity objEntity = new ObjEntity(objEntityName);
            objEntity.setDbEntity(dbEntity);
            objEntity.setClassName(config.getGenericClassName() != null ? config.getGenericClassName() : map.getNameWithDefaultPackage(objEntity.getName()));
            map.addObjEntity(objEntity);
            loadedEntities.add(objEntity);
        }
        return loadedEntities;
    }

    protected EntityMergeSupport createEntityMerger(DataMap map) {
        return new EntityMergeSupport(map, this.nameGenerator, !this.creatingMeaningfulPK);
    }

    protected void loadDbRelationships(DbLoaderConfiguration config, String catalog, String schema, List<DbEntity> tables) throws SQLException {
        if (config.isSkipRelationshipsLoading()) {
            return;
        }
        HashMap<String, DbEntity> tablesMap = new HashMap<String, DbEntity>();
        for (DbEntity table : tables) {
            tablesMap.put(table.getName(), table);
        }
        Map<String, Set<ExportedKey>> keys = this.loadExportedKeys(config, catalog, schema, tablesMap);
        for (Map.Entry<String, Set<ExportedKey>> entry : keys.entrySet()) {
            Set<ExportedKey> exportedKeys;
            ExportedKey key;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Process keys for: " + entry.getKey()));
            }
            if ((key = (exportedKeys = entry.getValue()).iterator().next()) == null) {
                throw new IllegalStateException();
            }
            DbEntity pkEntity = (DbEntity)tablesMap.get(key.getPKTableName());
            if (pkEntity == null) {
                this.skipRelationLog(key, key.getPKTableName());
                continue;
            }
            DbEntity fkEntity = (DbEntity)tablesMap.get(key.getFKTableName());
            if (fkEntity == null) {
                this.skipRelationLog(key, key.getFKTableName());
                continue;
            }
            if (!new EqualsBuilder().append(pkEntity.getCatalog(), key.pkCatalog).append(pkEntity.getSchema(), key.pkSchema).append(fkEntity.getCatalog(), key.fkCatalog).append(fkEntity.getSchema(), key.fkSchema).isEquals()) {
                LOGGER.info((Object)("Skip relation: '" + key + "' because it related to objects from other catalog/schema"));
                LOGGER.info((Object)("     relation primary key: '" + key.pkCatalog + "." + key.pkSchema + "'"));
                LOGGER.info((Object)("       primary key entity: '" + pkEntity.getCatalog() + "." + pkEntity.getSchema() + "'"));
                LOGGER.info((Object)("     relation foreign key: '" + key.fkCatalog + "." + key.fkSchema + "'"));
                LOGGER.info((Object)("       foreign key entity: '" + fkEntity.getCatalog() + "." + fkEntity.getSchema() + "'"));
                continue;
            }
            DbRelationship forwardRelationship = new DbRelationship(this.generateName(pkEntity, key, true));
            forwardRelationship.setSourceEntity(pkEntity);
            forwardRelationship.setTargetEntityName(fkEntity);
            DbRelationshipDetected reverseRelationship = new DbRelationshipDetected(this.generateName(fkEntity, key, false));
            reverseRelationship.setFkName(key.getFKName());
            reverseRelationship.setSourceEntity(fkEntity);
            reverseRelationship.setTargetEntityName(pkEntity);
            reverseRelationship.setToMany(false);
            this.createAndAppendJoins(exportedKeys, pkEntity, fkEntity, forwardRelationship, reverseRelationship);
            boolean toDependentPK = this.isToDependentPK(forwardRelationship);
            forwardRelationship.setToDependentPK(toDependentPK);
            boolean isOneToOne = toDependentPK && fkEntity.getPrimaryKeys().size() == forwardRelationship.getJoins().size();
            forwardRelationship.setToMany(!isOneToOne);
            forwardRelationship.setName(this.generateName(pkEntity, key, !isOneToOne));
            if (this.delegate.dbRelationshipLoaded(fkEntity, reverseRelationship)) {
                fkEntity.addRelationship(reverseRelationship);
            }
            if (!this.delegate.dbRelationshipLoaded(pkEntity, forwardRelationship)) continue;
            pkEntity.addRelationship(forwardRelationship);
        }
    }

    private boolean isToDependentPK(DbRelationship forwardRelationship) {
        for (DbJoin dbJoin : forwardRelationship.getJoins()) {
            if (dbJoin.getTarget().isPrimaryKey()) continue;
            return false;
        }
        return true;
    }

    private void createAndAppendJoins(Set<ExportedKey> exportedKeys, DbEntity pkEntity, DbEntity fkEntity, DbRelationship forwardRelationship, DbRelationshipDetected reverseRelationship) {
        for (ExportedKey exportedKey : exportedKeys) {
            String pkName = exportedKey.getPKColumnName();
            String fkName = exportedKey.getFKColumnName();
            DbAttribute pkAtt = pkEntity.getAttribute(pkName);
            if (pkAtt == null) {
                LOGGER.info((Object)("no attribute for declared primary key: " + pkName));
                continue;
            }
            DbAttribute fkAtt = fkEntity.getAttribute(fkName);
            if (fkAtt == null) {
                LOGGER.info((Object)("no attribute for declared foreign key: " + fkName));
                continue;
            }
            forwardRelationship.addJoin(new DbJoin(forwardRelationship, pkName, fkName));
            reverseRelationship.addJoin(new DbJoin(reverseRelationship, fkName, pkName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<ExportedKey>> loadExportedKeys(DbLoaderConfiguration config, String catalog, String schema, Map<String, DbEntity> tables) throws SQLException {
        HashMap<String, Set<ExportedKey>> keys = new HashMap<String, Set<ExportedKey>>();
        for (DbEntity dbEntity : tables.values()) {
            ResultSet rs;
            if (!this.delegate.dbRelationship(dbEntity)) continue;
            try {
                rs = this.getMetaData().getExportedKeys(catalog, schema, dbEntity.getName());
            }
            catch (SQLException cay182Ex) {
                LOGGER.info((Object)("Error getting relationships for '" + catalog + "." + schema + "', ignoring. " + cay182Ex.getMessage()), (Throwable)cay182Ex);
                return new HashMap<String, Set<ExportedKey>>();
            }
            try {
                while (rs.next()) {
                    ExportedKey key = ExportedKey.extractData(rs);
                    DbEntity fkEntity = tables.get(key.getFKTableName());
                    if (fkEntity == null) {
                        this.skipRelationLog(key, key.getFKTableName());
                        continue;
                    }
                    if (config.getFiltersConfig().tableFilter(fkEntity.getCatalog(), fkEntity.getSchema()).isIncludeTable(fkEntity.getName()) == null) continue;
                    TreeSet<ExportedKey> exportedKeys = (TreeSet<ExportedKey>)keys.get(key.getStrKey());
                    if (exportedKeys == null) {
                        exportedKeys = new TreeSet<ExportedKey>();
                        keys.put(key.getStrKey(), exportedKeys);
                    }
                    exportedKeys.add(key);
                }
            }
            finally {
                rs.close();
            }
        }
        return keys;
    }

    private void skipRelationLog(ExportedKey key, String tableName) {
        LOGGER.info((Object)("Skip relation: '" + key + "' because table '" + tableName + "' not found"));
    }

    private String generateName(DbEntity entity, ExportedKey key, boolean toMany) {
        String forwardPreferredName = this.nameGenerator.createDbRelationshipName(key, toMany);
        return DefaultUniqueNameGenerator.generate(NameCheckers.dbRelationship, entity, forwardPreferredName);
    }

    public static void flattenManyToManyRelationships(DataMap map, Collection<ObjEntity> loadedObjEntities, ObjectNameGenerator objectNameGenerator) {
        if (loadedObjEntities.isEmpty()) {
            return;
        }
        LinkedList<ObjEntity> entitiesForDelete = new LinkedList<ObjEntity>();
        for (ObjEntity curEntity : loadedObjEntities) {
            ManyToManyCandidateEntity entity = ManyToManyCandidateEntity.build(curEntity);
            if (entity == null) continue;
            entity.optimizeRelationships(objectNameGenerator);
            entitiesForDelete.add(curEntity);
        }
        for (ObjEntity curDeleteEntity : entitiesForDelete) {
            map.removeObjEntity(curDeleteEntity.getName(), true);
        }
        loadedObjEntities.removeAll(entitiesForDelete);
    }

    private void fireObjEntitiesAddedEvents(Collection<ObjEntity> loadedObjEntities) {
        for (ObjEntity curEntity : loadedObjEntities) {
            if (this.delegate == null) continue;
            this.delegate.objEntityAdded(curEntity);
        }
    }

    public String[] getDefaultTableTypes() {
        String tableType;
        ArrayList<String> list = new ArrayList<String>(2);
        String viewType = this.adapter.tableTypeForView();
        if (viewType != null) {
            list.add(viewType);
        }
        if ((tableType = this.adapter.tableTypeForTable()) != null) {
            list.add(tableType);
        }
        return list.toArray(new String[list.size()]);
    }

    @Deprecated
    public DataMap loadDataMapFromDB(String schemaPattern, String tablePattern, DataMap dataMap) throws SQLException {
        DbLoaderConfiguration configuration = new DbLoaderConfiguration();
        configuration.setFiltersConfig(FiltersConfig.create(null, schemaPattern, TableFilter.include(tablePattern), PatternFilter.INCLUDE_NOTHING));
        this.load(dataMap, configuration);
        return dataMap;
    }

    @Deprecated
    public DataMap loadDataMapFromDB(String schemaPattern, String tablePattern, String[] tableTypes, DataMap dataMap) throws SQLException {
        dataMap.clear();
        DbLoaderConfiguration config = new DbLoaderConfiguration();
        config.setFiltersConfig(FiltersConfig.create(null, schemaPattern, TableFilter.include(tablePattern), PatternFilter.INCLUDE_NOTHING));
        config.setTableTypes(tableTypes);
        this.load(dataMap, config);
        return dataMap;
    }

    public void load(DataMap dataMap, DbLoaderConfiguration config) throws SQLException {
        LOGGER.info((Object)"Schema loading...");
        String[] types = config.getTableTypes();
        if (types == null || types.length == 0) {
            types = this.getDefaultTableTypes();
        }
        for (CatalogFilter catalog : config.getFiltersConfig().catalogs) {
            for (SchemaFilter schema : catalog.schemas) {
                List<DbEntity> entities = this.createTableLoader(catalog.name, schema.name, schema.tables).loadDbEntities(dataMap, config, types);
                if (entities == null) continue;
                this.loadDbRelationships(config, catalog.name, schema.name, entities);
                this.prepareObjLayer(dataMap, config, entities);
            }
        }
    }

    protected DbTableLoader createTableLoader(String catalog, String schema, TableFilter filter) throws SQLException {
        return new DbTableLoader(catalog, schema, this.getMetaData(), this.delegate, new DbAttributesPerSchemaLoader(catalog, schema, this.getMetaData(), this.adapter, filter));
    }

    public void prepareObjLayer(DataMap dataMap, DbLoaderConfiguration config, Collection<DbEntity> entities) {
        Collection<ObjEntity> loadedObjEntities = this.loadObjEntities(dataMap, config, entities);
        DbLoader.flattenManyToManyRelationships(dataMap, loadedObjEntities, this.getNameGenerator());
        this.fireObjEntitiesAddedEvents(loadedObjEntities);
    }

    public DataMap load(DbLoaderConfiguration config) throws SQLException {
        DataMap dataMap = new DataMap();
        this.load(dataMap, config);
        this.loadProcedures(dataMap, config);
        return dataMap;
    }

    @Deprecated
    public void loadProceduresFromDB(String schemaPattern, String namePattern, DataMap dataMap) throws SQLException {
        DbLoaderConfiguration configuration = new DbLoaderConfiguration();
        configuration.setFiltersConfig(FiltersConfig.create(null, schemaPattern, TableFilter.everything(), new PatternFilter().include(namePattern)));
        this.loadProcedures(dataMap, configuration);
    }

    public Map<String, Procedure> loadProcedures(DataMap dataMap, DbLoaderConfiguration config) throws SQLException {
        Map<String, Procedure> procedures = this.loadProcedures(config);
        if (procedures.isEmpty()) {
            return procedures;
        }
        this.loadProceduresColumns(config, procedures);
        for (Procedure procedure : procedures.values()) {
            dataMap.addProcedure(procedure);
        }
        return procedures;
    }

    private void loadProceduresColumns(DbLoaderConfiguration config, Map<String, Procedure> procedures) throws SQLException {
        for (CatalogFilter catalog : config.getFiltersConfig().catalogs) {
            for (SchemaFilter schema : catalog.schemas) {
                this.loadProceduresColumns(procedures, catalog.name, schema.name);
            }
        }
    }

    private void loadProceduresColumns(Map<String, Procedure> procedures, String catalog, String schema) throws SQLException {
        try (ResultSet columnsRS = this.getMetaData().getProcedureColumns(catalog, schema, null, null);){
            while (columnsRS.next()) {
                ProcedureParameter column;
                String s = columnsRS.getString("PROCEDURE_SCHEM");
                String name = columnsRS.getString("PROCEDURE_NAME");
                String key = (s == null ? "" : s + '.') + name;
                Procedure procedure = procedures.get(key);
                if (procedure == null || (column = this.loadProcedureParams(columnsRS, key, procedure)) == null) continue;
                procedure.addCallParameter(column);
            }
        }
    }

    private ProcedureParameter loadProcedureParams(ResultSet columnsRS, String key, Procedure procedure) throws SQLException {
        String columnName = columnsRS.getString("COLUMN_NAME");
        short type = columnsRS.getShort("COLUMN_TYPE");
        if (type == 3) {
            LOGGER.debug((Object)("skipping ResultSet column: " + key + "." + columnName));
        }
        if (columnName == null) {
            if (type == 5) {
                LOGGER.debug((Object)("null column name, assuming result column: " + key));
                columnName = "_return_value";
                procedure.setReturningValue(true);
            } else {
                LOGGER.info((Object)("invalid null column name, skipping column : " + key));
                return null;
            }
        }
        int columnType = columnsRS.getInt("DATA_TYPE");
        int decimalDigits = -1;
        if (TypesMapping.isDecimal(columnType)) {
            decimalDigits = columnsRS.getShort("SCALE");
            if (columnsRS.wasNull()) {
                decimalDigits = -1;
            }
        }
        ProcedureParameter column = new ProcedureParameter(columnName);
        int direction = DbLoader.getDirection(type);
        if (direction != -1) {
            column.setDirection(direction);
        }
        column.setType(columnType);
        column.setMaxLength(columnsRS.getInt("LENGTH"));
        column.setPrecision(decimalDigits);
        column.setProcedure(procedure);
        return column;
    }

    private static int getDirection(short type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 4: {
                return 2;
            }
        }
        return -1;
    }

    private Map<String, Procedure> loadProcedures(DbLoaderConfiguration config) throws SQLException {
        HashMap<String, Procedure> procedures = new HashMap<String, Procedure>();
        FiltersConfig filters = config.getFiltersConfig();
        for (CatalogFilter catalog : filters.catalogs) {
            for (SchemaFilter schema : catalog.schemas) {
                if (filters.proceduresFilter(catalog.name, schema.name).isEmpty()) continue;
                procedures.putAll(this.loadProcedures(filters, catalog.name, schema.name));
            }
        }
        return procedures;
    }

    private Map<String, Procedure> loadProcedures(FiltersConfig filters, String catalog, String schema) throws SQLException {
        HashMap<String, Procedure> procedures = new HashMap<String, Procedure>();
        try (ResultSet rs = this.getMetaData().getProcedures(catalog, schema, WILDCARD);){
            while (rs.next()) {
                String name = rs.getString("PROCEDURE_NAME");
                Procedure procedure = new Procedure(name);
                procedure.setCatalog(rs.getString("PROCEDURE_CAT"));
                procedure.setSchema(rs.getString("PROCEDURE_SCHEM"));
                if (filters.proceduresFilter(procedure.getCatalog(), procedure.getSchema()).isInclude(procedure.getName())) {
                    LOGGER.info((Object)("skipping Cayenne PK procedure: " + name));
                    continue;
                }
                switch (rs.getShort("PROCEDURE_TYPE")) {
                    case 0: 
                    case 1: {
                        procedure.setReturningValue(false);
                        break;
                    }
                    case 2: {
                        procedure.setReturningValue(true);
                    }
                }
                procedures.put(procedure.getFullyQualifiedName(), procedure);
            }
        }
        return procedures;
    }

    public void setNameGenerator(ObjectNameGenerator strategy) {
        if (strategy == null) {
            LOGGER.warn((Object)"Attempt to set null into NameGenerator. LegacyNameGenerator will be used.");
            this.nameGenerator = new LegacyNameGenerator();
        } else {
            this.nameGenerator = strategy;
        }
    }

    public ObjectNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }
}

