/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNodeQueryAction;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.access.TransactionConnectionDecorator;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategy;
import org.apache.cayenne.access.dbsync.SkipSchemaUpdateStrategy;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.SQLTemplateProcessor;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.access.translator.batch.BatchTranslator;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.access.translator.select.SelectTranslatorFactory;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.log.NoopJdbcEventLogger;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.util.ToStringBuilder;

public class DataNode
implements QueryEngine {
    protected String name;
    protected DataSource dataSource;
    protected DbAdapter adapter;
    protected String dataSourceLocation;
    protected String dataSourceFactory;
    protected String schemaUpdateStrategyName;
    protected EntityResolver entityResolver;
    protected SchemaUpdateStrategy schemaUpdateStrategy;
    protected Map<String, DataMap> dataMaps;
    private JdbcEventLogger jdbcEventLogger;
    private RowReaderFactory rowReaderFactory;
    private BatchTranslatorFactory batchTranslatorFactory;
    private SelectTranslatorFactory selectTranslatorFactory;
    private SQLTemplateProcessor sqlTemplateProcessor;
    TransactionDataSource readThroughDataSource;

    public DataNode() {
        this(null);
    }

    public DataNode(String name) {
        this.name = name;
        this.dataMaps = new HashMap<String, DataMap>();
        this.readThroughDataSource = new TransactionDataSource();
        this.jdbcEventLogger = NoopJdbcEventLogger.getInstance();
    }

    public String getSchemaUpdateStrategyName() {
        if (this.schemaUpdateStrategyName == null) {
            this.schemaUpdateStrategyName = SkipSchemaUpdateStrategy.class.getName();
        }
        return this.schemaUpdateStrategyName;
    }

    public void setSchemaUpdateStrategyName(String schemaUpdateStrategyName) {
        this.schemaUpdateStrategyName = schemaUpdateStrategyName;
    }

    public SchemaUpdateStrategy getSchemaUpdateStrategy() {
        return this.schemaUpdateStrategy;
    }

    public void setSchemaUpdateStrategy(SchemaUpdateStrategy schemaUpdateStrategy) {
        this.schemaUpdateStrategy = schemaUpdateStrategy;
    }

    public JdbcEventLogger getJdbcEventLogger() {
        if (this.jdbcEventLogger == null && this.adapter instanceof JdbcAdapter) {
            this.jdbcEventLogger = ((JdbcAdapter)this.adapter).getJdbcEventLogger();
        }
        return this.jdbcEventLogger;
    }

    public void setJdbcEventLogger(JdbcEventLogger logger) {
        this.jdbcEventLogger = logger;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDataSourceLocation() {
        return this.dataSourceLocation;
    }

    public void setDataSourceLocation(String dataSourceLocation) {
        this.dataSourceLocation = dataSourceLocation;
    }

    public String getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public void setDataSourceFactory(String dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public Collection<DataMap> getDataMaps() {
        return Collections.unmodifiableCollection(this.dataMaps.values());
    }

    public DataMap getDataMap(String name) {
        return this.dataMaps.get(name);
    }

    public void setDataMaps(Collection<DataMap> dataMaps) {
        for (DataMap map : dataMaps) {
            this.dataMaps.put(map.getName(), map);
        }
    }

    public void addDataMap(DataMap map) {
        this.dataMaps.put(map.getName(), map);
    }

    public void removeDataMap(DataMap map) {
        this.removeDataMap(map.getName());
    }

    public void removeDataMap(String mapName) {
        this.dataMaps.remove(mapName);
    }

    public DataSource getDataSource() {
        return this.dataSource != null ? this.readThroughDataSource : null;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(DbAdapter adapter) {
        this.adapter = adapter;
    }

    public DataNode lookupDataNode(DataMap dataMap) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performQueries(Collection<? extends Query> queries, OperationObserver callback) {
        int listSize = queries.size();
        if (listSize == 0) {
            return;
        }
        if (callback.isIteratedResult() && listSize > 1) {
            throw new CayenneRuntimeException("Iterated queries are not allowed in a batch. Batch size: " + listSize, new Object[0]);
        }
        this.getAdapter().getExtendedTypes();
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
        }
        catch (Exception globalEx) {
            this.getJdbcEventLogger().logQueryError(globalEx);
            Transaction transaction = BaseTransaction.getThreadTransaction();
            if (transaction != null) {
                transaction.setRollbackOnly();
            }
            callback.nextGlobalException(globalEx);
            return;
        }
        try {
            DataNodeQueryAction queryRunner = new DataNodeQueryAction(this, callback);
            for (Query query : queries) {
                try {
                    queryRunner.runQuery(connection, query);
                }
                catch (Exception queryEx) {
                    this.getJdbcEventLogger().logQueryError(queryEx);
                    callback.nextQueryException(query, queryEx);
                    Transaction transaction = BaseTransaction.getThreadTransaction();
                    if (transaction != null) {
                        transaction.setRollbackOnly();
                    }
                    break;
                }
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {}
        }
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.getName()).toString();
    }

    public RowReader<?> rowReader(RowDescriptor descriptor, QueryMetadata queryMetadata) {
        return this.rowReader(descriptor, queryMetadata, Collections.emptyMap());
    }

    public RowReader<?> rowReader(RowDescriptor descriptor, QueryMetadata queryMetadata, Map<ObjAttribute, ColumnDescriptor> attributeOverrides) {
        return this.rowReaderFactory.rowReader(descriptor, queryMetadata, this.getAdapter(), attributeOverrides);
    }

    public BatchTranslator batchTranslator(BatchQuery query, String trimFunction) {
        return this.batchTranslatorFactory.translator(query, this.getAdapter(), trimFunction);
    }

    public SelectTranslator selectTranslator(SelectQuery<?> query) {
        return this.selectTranslatorFactory.translator(query, this.getAdapter(), this.getEntityResolver());
    }

    public RowReaderFactory getRowReaderFactory() {
        return this.rowReaderFactory;
    }

    public void setRowReaderFactory(RowReaderFactory rowReaderFactory) {
        this.rowReaderFactory = rowReaderFactory;
    }

    public BatchTranslatorFactory getBatchTranslatorFactory() {
        return this.batchTranslatorFactory;
    }

    public void setBatchTranslatorFactory(BatchTranslatorFactory batchTranslatorFactory) {
        this.batchTranslatorFactory = batchTranslatorFactory;
    }

    public SQLTemplateProcessor getSqlTemplateProcessor() {
        return this.sqlTemplateProcessor;
    }

    public void setSqlTemplateProcessor(SQLTemplateProcessor sqlTemplateProcessor) {
        this.sqlTemplateProcessor = sqlTemplateProcessor;
    }

    public SelectTranslatorFactory getSelectTranslatorFactory() {
        return this.selectTranslatorFactory;
    }

    public void setSelectTranslatorFactory(SelectTranslatorFactory selectTranslatorFactory) {
        this.selectTranslatorFactory = selectTranslatorFactory;
    }

    final class TransactionDataSource
    implements DataSource {
        final String CONNECTION_RESOURCE_PREFIX = "DataNode.Connection.";

        TransactionDataSource() {
        }

        @Override
        public Connection getConnection() throws SQLException {
            Transaction t;
            if (DataNode.this.schemaUpdateStrategy != null) {
                DataNode.this.schemaUpdateStrategy.updateSchema(DataNode.this);
            }
            if ((t = BaseTransaction.getThreadTransaction()) != null) {
                String key = "DataNode.Connection." + DataNode.this.name;
                Connection c = t.getConnection(key);
                if (c == null || c.isClosed()) {
                    c = DataNode.this.dataSource.getConnection();
                    t.addConnection(key, c);
                }
                return new TransactionConnectionDecorator(c);
            }
            return DataNode.this.dataSource.getConnection();
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            Transaction t;
            if (DataNode.this.schemaUpdateStrategy != null) {
                DataNode.this.schemaUpdateStrategy.updateSchema(DataNode.this);
            }
            if ((t = BaseTransaction.getThreadTransaction()) != null) {
                String key = "DataNode.Connection." + DataNode.this.name;
                Connection c = t.getConnection(key);
                if (c == null || c.isClosed()) {
                    c = DataNode.this.dataSource.getConnection();
                    t.addConnection(key, c);
                }
                return new TransactionConnectionDecorator(c);
            }
            return DataNode.this.dataSource.getConnection(username, password);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return DataNode.this.dataSource.getLoginTimeout();
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return DataNode.this.dataSource.getLogWriter();
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            DataNode.this.dataSource.setLoginTimeout(seconds);
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            DataNode.this.dataSource.setLogWriter(out);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return iface.isAssignableFrom(DataNode.this.dataSource.getClass());
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            try {
                return iface.cast(DataNode.this.dataSource);
            }
            catch (ClassCastException e) {
                throw new SQLException("Not a DataSource: " + e.getMessage());
            }
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new UnsupportedOperationException();
        }
    }
}

