/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.configuration.ObjectStoreFactory;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.event.DefaultEventManager;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.test.parallel.ParallelTestContainer;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextSharedCacheEmpiricIT
extends ServerCase {
    private static final String NEW_NAME = "versionX";
    @Inject
    private ServerRuntime runtime;
    @Inject
    private ObjectStoreFactory objectStoreFactory;
    @Inject
    private DBHelper dbHelper;
    private DataContext c1;
    private DataContext c2;

    @Before
    public void setUp() throws Exception {
        DataRowStore cache = new DataRowStore("cacheTest", Collections.EMPTY_MAP, new DefaultEventManager());
        this.c1 = new DataContext(this.runtime.getDataDomain(), this.objectStoreFactory.createObjectStore(cache));
        this.c2 = new DataContext(this.runtime.getDataDomain(), this.objectStoreFactory.createObjectStore(cache));
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        tArtist.insert(new Object[]{1, "version1"});
    }

    @Test
    public void testSelectSelectCommitRefresh() throws Exception {
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        List artists = this.c1.performQuery(query);
        Artist a1 = (Artist)artists.get(0);
        List altArtists = this.c2.performQuery(query);
        Artist a2 = (Artist)altArtists.get(0);
        Assert.assertNotNull((Object)a2);
        Assert.assertFalse((a2 == a1 ? 1 : 0) != 0);
        a1.setArtistName(NEW_NAME);
        this.c1.commitChanges();
        this.assertOnCommit(a2);
    }

    @Test
    public void testSelectSelectCommitRefreshReverse() throws Exception {
        List artists;
        Artist a1;
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        List altArtists = this.c2.performQuery(query);
        Artist a2 = (Artist)altArtists.get(0);
        Assert.assertFalse((a2 == (a1 = (Artist)(artists = this.c1.performQuery(query)).get(0)) ? 1 : 0) != 0);
        a1.setArtistName(NEW_NAME);
        this.c1.commitChanges();
        this.assertOnCommit(a2);
    }

    @Test
    public void testSelectUpdateSelectCommitRefresh() throws Exception {
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        List artists = this.c1.performQuery(query);
        Artist a1 = (Artist)artists.get(0);
        a1.setArtistName(NEW_NAME);
        List altArtists = this.c2.performQuery(query);
        Artist a2 = (Artist)altArtists.get(0);
        Assert.assertNotNull((Object)a2);
        Assert.assertFalse((a2 == a1 ? 1 : 0) != 0);
        this.c1.commitChanges();
        this.assertOnCommit(a2);
    }

    private void assertOnCommit(final Artist a2) throws Exception {
        final DataRow freshSnapshot = this.c2.getObjectStore().getDataRowCache().getCachedSnapshot(a2.getObjectId());
        Assert.assertNotNull((String)"No snapshot for artist", (Object)freshSnapshot);
        Assert.assertEquals((Object)NEW_NAME, freshSnapshot.get("ARTIST_NAME"));
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((String)("Snapshot change is not propagated: " + freshSnapshot), (Object)DataContextSharedCacheEmpiricIT.NEW_NAME, (Object)a2.getArtistName());
            }
        };
        helper.runTest(3000L);
    }
}

