/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.meaningful_pk.MeaningfulPKDep;
import org.apache.cayenne.testdo.meaningful_pk.MeaningfulPKTest1;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-meaningful-pk.xml")
public class DataContextEntityWithMeaningfulPKIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testInsertWithMeaningfulPK() throws Exception {
        MeaningfulPKTest1 obj = this.context.newObject(MeaningfulPKTest1.class);
        obj.setPkAttribute(1000);
        obj.setDescr("aaa-aaa");
        this.context.commitChanges();
        ObjectIdQuery q = new ObjectIdQuery(new ObjectId("MeaningfulPKTest1", "PK_ATTRIBUTE", 1000), true, 2);
        Assert.assertEquals((long)1L, (long)this.context.performQuery(q).size());
    }

    @Test
    public void testGeneratedKey() throws Exception {
        MeaningfulPKTest1 obj = this.context.newObject(MeaningfulPKTest1.class);
        obj.setDescr("aaa-aaa");
        this.context.commitChanges();
        Assert.assertNotNull((Object)obj.getPkAttribute());
        Assert.assertSame((Object)obj, (Object)Cayenne.objectForPK((ObjectContext)this.context, MeaningfulPKTest1.class, (Object)obj.getPkAttribute()));
        int id = Cayenne.intPKForObject(obj);
        DataRow snapshot = this.context.getObjectStore().getDataRowCache().getCachedSnapshot(obj.getObjectId());
        Assert.assertNotNull((Object)snapshot);
        Assert.assertTrue((boolean)snapshot.containsKey("PK_ATTRIBUTE"));
        Assert.assertEquals((Object)new Integer(id), snapshot.get("PK_ATTRIBUTE"));
    }

    @Test
    public void testChangeKey() throws Exception {
        MeaningfulPKTest1 obj = (MeaningfulPKTest1)this.context.newObject("MeaningfulPKTest1");
        obj.setPkAttribute(new Integer(1000));
        obj.setDescr("aaa-aaa");
        this.context.commitChanges();
        obj.setPkAttribute(new Integer(2000));
        this.context.commitChanges();
        ObjectId id = obj.getObjectId();
        Assert.assertEquals((Object)new Integer(2000), (Object)id.getIdSnapshot().get("PK_ATTRIBUTE"));
    }

    @Test
    public void testToManyRelationshipWithMeaningfulPK1() throws Exception {
        MeaningfulPKTest1 obj = (MeaningfulPKTest1)this.context.newObject("MeaningfulPKTest1");
        obj.setPkAttribute(new Integer(1000));
        obj.setDescr("aaa-aaa");
        this.context.commitChanges();
        ObjectContext context = this.runtime.newContext();
        List objects = context.performQuery(new SelectQuery<MeaningfulPKTest1>(MeaningfulPKTest1.class));
        Assert.assertEquals((long)1L, (long)objects.size());
        obj = (MeaningfulPKTest1)objects.get(0);
        Assert.assertEquals((long)0L, (long)obj.getMeaningfulPKDepArray().size());
    }

    @Test
    public void testToManyRelationshipWithMeaningfulPK2() throws Exception {
        MeaningfulPKTest1 obj = (MeaningfulPKTest1)this.context.newObject("MeaningfulPKTest1");
        obj.setPkAttribute(new Integer(1000));
        obj.setDescr("aaa-aaa");
        this.context.commitChanges();
        MeaningfulPKDep dep = (MeaningfulPKDep)this.context.newObject("MeaningfulPKDep");
        dep.setToMeaningfulPK(obj);
        this.context.commitChanges();
    }
}

