/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.relationships_collection_to_many.CollectionToMany;
import org.apache.cayenne.testdo.relationships_collection_to_many.CollectionToManyTarget;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-collection-to-many.xml")
public class CayenneDataObjectSetToManyCollectionIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void setUp() throws Exception {
        TableHelper tCollectionToMany = new TableHelper(this.dbHelper, "COLLECTION_TO_MANY");
        tCollectionToMany.setColumns(new String[]{"ID"});
        TableHelper tCollectionToManyTarget = new TableHelper(this.dbHelper, "COLLECTION_TO_MANY_TARGET");
        tCollectionToManyTarget.setColumns(new String[]{"ID", "COLLECTION_TO_MANY_ID"});
        tCollectionToMany.insert(new Object[]{1}).insert(new Object[]{2});
        tCollectionToManyTarget.insert(new Object[]{1, 1}).insert(new Object[]{2, 1}).insert(new Object[]{3, 1}).insert(new Object[]{4, 2});
    }

    @Test
    public void testReadToMany() throws Exception {
        CollectionToMany o1 = Cayenne.objectForPK(this.context, CollectionToMany.class, 1);
        Collection<CollectionToManyTarget> targets = o1.getTargets();
        Assert.assertNotNull(targets);
        Assert.assertTrue((boolean)((ValueHolder)((Object)targets)).isFault());
        Assert.assertEquals((long)3L, (long)targets.size());
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), CollectionToManyTarget.class, 1)));
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), CollectionToManyTarget.class, 2)));
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), CollectionToManyTarget.class, 3)));
    }

    @Test
    public void testRelationCollectionTypeCollection() throws Exception {
        CollectionToMany o1 = Cayenne.objectForPK(this.context, CollectionToMany.class, 1);
        Assert.assertTrue((boolean)(o1.readProperty("targets") instanceof Collection));
        boolean catchedSomething = false;
        try {
            o1.setToManyTarget("targets", new ArrayList(0), true);
        }
        catch (RuntimeException e) {
            catchedSomething = true;
        }
        Assert.assertEquals((Object)catchedSomething, (Object)false);
        Assert.assertEquals((long)o1.getTargets().size(), (long)0L);
    }
}

