/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map.naming;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.naming.NameChecker;
import org.apache.cayenne.map.naming.NameCheckers;
import org.apache.cayenne.map.naming.UniqueNameGenerator;

public class DefaultUniqueNameGenerator
implements UniqueNameGenerator {
    public static final String DEFAULT_PATTERN = "%s%d";
    private final NameChecker nameChecker;
    private final String pattern;

    public static String generate(NameChecker checker) {
        return DefaultUniqueNameGenerator.generate(checker, DEFAULT_PATTERN, null, null);
    }

    public static String generate(NameChecker checker, Object context) {
        return DefaultUniqueNameGenerator.generate(checker, DEFAULT_PATTERN, context, null);
    }

    public static String generate(NameChecker checker, Object context, String baseName) {
        return DefaultUniqueNameGenerator.generate(checker, DEFAULT_PATTERN, context, baseName);
    }

    public static String generate(NameChecker checker, String pattern, Object context, String baseName) {
        DefaultUniqueNameGenerator generator = checker == NameCheckers.embeddable ? new DefaultUniqueNameGenerator(NameCheckers.embeddable, pattern){

            @Override
            public String generate(Object namingContext, String nameBase) {
                return ((DataMap)namingContext).getNameWithDefaultPackage(super.generate(namingContext, nameBase));
            }
        } : new DefaultUniqueNameGenerator(checker, pattern);
        return generator.generate(context, baseName);
    }

    public DefaultUniqueNameGenerator(NameChecker nameChecker, String pattern) {
        this.nameChecker = nameChecker;
        this.pattern = pattern;
    }

    @Override
    public String generate(Object namingContext) {
        return this.generate(namingContext, this.nameChecker.baseName());
    }

    @Override
    public String generate(Object namingContext, String nameBase) {
        return this.generate(this.pattern, namingContext, nameBase != null ? nameBase : this.nameChecker.baseName());
    }

    private String generate(String pattern, Object namingContext, String nameBase) {
        int c = 1;
        String name = nameBase;
        while (this.nameChecker.isNameInUse(namingContext, name)) {
            name = String.format(pattern, nameBase, c++);
        }
        return name;
    }
}

