/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.CallbackDescriptor;
import org.apache.cayenne.map.ClientEntityResolver;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.EntityListenerFactory;
import org.apache.cayenne.map.MappingCache;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProxiedMappingNamespace;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.reflect.SingletonFaultFactory;
import org.apache.cayenne.reflect.generic.DataObjectDescriptorFactory;
import org.apache.cayenne.reflect.valueholder.ValueHolderDescriptorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityResolver
implements MappingNamespace,
Serializable {
    protected static final Log logger = LogFactory.getLog(EntityResolver.class);
    @Deprecated
    protected boolean indexedByClass;
    protected Collection<DataMap> maps;
    protected transient MappingNamespace mappingCache;
    protected EntityResolver clientEntityResolver;
    protected volatile transient ClassDescriptorMap classDescriptorMap;
    protected transient LifecycleCallbackRegistry callbackRegistry;

    public EntityResolver() {
        this(Collections.emptyList());
    }

    public EntityResolver(Collection<DataMap> dataMaps) {
        this.maps = new ArrayList<DataMap>(dataMaps);
        this.refreshMappingCache();
    }

    public void applyDBLayerDefaults() {
        for (DataMap map : this.getDataMaps()) {
            for (DbEntity entity : map.getDbEntities()) {
                DbRelationship[] relationships;
                for (DbRelationship relationship : relationships = entity.getRelationships().toArray(new DbRelationship[entity.getRelationships().size()])) {
                    if (relationship.getReverseRelationship() != null) continue;
                    DbRelationship reverse = relationship.createReverseRelationship();
                    DbEntity targetEntity = reverse.getSourceEntity();
                    reverse.setName(this.makeUniqueRelationshipName(targetEntity));
                    reverse.setRuntime(true);
                    targetEntity.addRelationship(reverse);
                    logger.info((Object)("added runtime complimentary DbRelationship from " + targetEntity.getName() + " to " + reverse.getTargetEntityName()));
                }
            }
        }
    }

    @Deprecated
    public void applyObjectLayerDefaults() {
    }

    private String makeUniqueRelationshipName(Entity entity) {
        for (int i = 0; i < 1000; ++i) {
            String name = "runtimeRelationship" + i;
            if (entity.getRelationship(name) != null) continue;
            return name;
        }
        throw new CayenneRuntimeException("Could not come up with a unique relationship name", new Object[0]);
    }

    synchronized void initCallbacks() {
        if (this.callbackRegistry == null) {
            LifecycleCallbackRegistry callbackRegistry = new LifecycleCallbackRegistry(this);
            for (ObjEntity entity : this.getObjEntities()) {
                CallbackDescriptor[] callbacks;
                Class<?> entityClass = entity.getJavaClass();
                for (CallbackDescriptor callback : callbacks = entity.getCallbackMap().getCallbacks()) {
                    for (String method : callback.getCallbackMethods()) {
                        callbackRegistry.addCallback(callback.getCallbackType(), entityClass, method);
                    }
                }
            }
            this.callbackRegistry = callbackRegistry;
        }
    }

    public LifecycleCallbackRegistry getCallbackRegistry() {
        if (this.callbackRegistry == null) {
            this.initCallbacks();
        }
        return this.callbackRegistry;
    }

    public void setCallbackRegistry(LifecycleCallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityResolver getClientEntityResolver() {
        if (this.clientEntityResolver == null) {
            EntityResolver entityResolver = this;
            synchronized (entityResolver) {
                if (this.clientEntityResolver == null) {
                    ClientEntityResolver resolver = new ClientEntityResolver();
                    for (DataMap map : this.getDataMaps()) {
                        DataMap clientMap = map.getClientDataMap(this);
                        if (clientMap == null) continue;
                        resolver.addDataMap(clientMap);
                    }
                    this.clientEntityResolver = resolver;
                }
            }
        }
        return this.clientEntityResolver;
    }

    @Override
    public Collection<DbEntity> getDbEntities() {
        return this.mappingCache.getDbEntities();
    }

    @Override
    public Collection<ObjEntity> getObjEntities() {
        return this.mappingCache.getObjEntities();
    }

    @Override
    public Collection<Embeddable> getEmbeddables() {
        return this.mappingCache.getEmbeddables();
    }

    @Deprecated
    public Collection<SQLResult> getResultSets() {
        return this.getResults();
    }

    @Override
    public Collection<SQLResult> getResults() {
        return this.mappingCache.getResults();
    }

    @Override
    public Collection<Procedure> getProcedures() {
        return this.mappingCache.getProcedures();
    }

    @Override
    public Collection<Query> getQueries() {
        return this.mappingCache.getQueries();
    }

    @Override
    public DbEntity getDbEntity(String name) {
        DbEntity result = this.mappingCache.getDbEntity(name);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getDbEntity(name);
        }
        return result;
    }

    @Override
    public ObjEntity getObjEntity(String name) {
        ObjEntity result = this.mappingCache.getObjEntity(name);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getObjEntity(name);
        }
        return result;
    }

    @Override
    public Procedure getProcedure(String procedureName) {
        Procedure result = this.mappingCache.getProcedure(procedureName);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getProcedure(procedureName);
        }
        return result;
    }

    @Override
    public Query getQuery(String name) {
        Query result = this.mappingCache.getQuery(name);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getQuery(name);
        }
        return result;
    }

    @Override
    public Embeddable getEmbeddable(String className) {
        Embeddable result = this.mappingCache.getEmbeddable(className);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getEmbeddable(className);
        }
        return result;
    }

    @Override
    public SQLResult getResult(String name) {
        SQLResult result = this.mappingCache.getResult(name);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getResult(name);
        }
        return result;
    }

    public ClassDescriptor getClassDescriptor(String entityName) {
        if (entityName == null) {
            throw new IllegalArgumentException("Null entityName");
        }
        return this.getClassDescriptorMap().getDescriptor(entityName);
    }

    public synchronized void addDataMap(DataMap map) {
        if (!this.maps.contains(map)) {
            this.maps.add(map);
            map.setNamespace(this);
            this.refreshMappingCache();
        }
    }

    @Deprecated
    public void clearCache() {
        this.refreshMappingCache();
    }

    public void refreshMappingCache() {
        this.mappingCache = new ProxiedMappingNamespace(){

            @Override
            protected MappingCache createDelegate() {
                return new MappingCache(EntityResolver.this.maps);
            }
        };
        this.clientEntityResolver = null;
    }

    public DataMap getDataMap(String mapName) {
        if (mapName == null) {
            return null;
        }
        for (DataMap map : this.maps) {
            if (!mapName.equals(map.getName())) continue;
            return map;
        }
        return null;
    }

    public synchronized void setDataMaps(Collection<DataMap> maps) {
        this.maps.clear();
        this.maps.addAll(maps);
        this.refreshMappingCache();
    }

    public Collection<DataMap> getDataMaps() {
        return Collections.unmodifiableCollection(this.maps);
    }

    @Override
    public EntityInheritanceTree getInheritanceTree(String entityName) {
        EntityInheritanceTree tree = this.mappingCache.getInheritanceTree(entityName);
        if (tree == null) {
            this.refreshMappingCache();
            tree = this.mappingCache.getInheritanceTree(entityName);
        }
        return tree;
    }

    @Deprecated
    public EntityInheritanceTree lookupInheritanceTree(String entityName) {
        return this.getInheritanceTree(entityName);
    }

    @Override
    public ObjEntity getObjEntity(Class<?> entityClass) {
        ObjEntity result = this.mappingCache.getObjEntity(entityClass);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getObjEntity(entityClass);
        }
        return result;
    }

    public ObjEntity lookupObjEntity(Class<?> entityClass) {
        return this.getObjEntity(entityClass);
    }

    @Override
    public ObjEntity getObjEntity(Persistent object) {
        return this.mappingCache.getObjEntity(object);
    }

    @Deprecated
    public ObjEntity lookupObjEntity(Object object) {
        if (object instanceof ObjEntity) {
            return (ObjEntity)object;
        }
        if (object instanceof Persistent) {
            ObjectId id = ((Persistent)object).getObjectId();
            if (id != null) {
                return this.getObjEntity(id.getEntityName());
            }
        } else if (object instanceof Class) {
            return this.getObjEntity((Class)object);
        }
        return this.getObjEntity(object.getClass());
    }

    @Deprecated
    public Procedure lookupProcedure(Query q) {
        return q.getMetaData(this).getProcedure();
    }

    @Deprecated
    public Procedure lookupProcedure(String procedureName) {
        return this.getProcedure(procedureName);
    }

    @Deprecated
    public Query lookupQuery(String name) {
        return this.getQuery(name);
    }

    public synchronized void removeDataMap(DataMap map) {
        if (this.maps.remove(map)) {
            this.refreshMappingCache();
        }
    }

    @Deprecated
    public boolean isIndexedByClass() {
        return this.indexedByClass;
    }

    public void setIndexedByClass(boolean b) {
        this.indexedByClass = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDescriptorMap getClassDescriptorMap() {
        if (this.classDescriptorMap == null) {
            EntityResolver entityResolver = this;
            synchronized (entityResolver) {
                if (this.classDescriptorMap == null) {
                    ClassDescriptorMap classDescriptorMap = new ClassDescriptorMap(this);
                    SingletonFaultFactory faultFactory = new SingletonFaultFactory();
                    classDescriptorMap.addFactory(new ValueHolderDescriptorFactory(classDescriptorMap));
                    classDescriptorMap.addFactory(new DataObjectDescriptorFactory(classDescriptorMap, faultFactory));
                    for (DataMap map : this.maps) {
                        for (String entityName : map.getObjEntityMap().keySet()) {
                            classDescriptorMap.getDescriptor(entityName);
                        }
                    }
                    this.classDescriptorMap = classDescriptorMap;
                }
            }
        }
        return this.classDescriptorMap;
    }

    @Deprecated
    public void setEntityListenerFactory(EntityListenerFactory entityListenerFactory) {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.refreshMappingCache();
    }
}

