/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.util.ConversionUtil;

public class ASTBitwiseLeftShift
extends SimpleNode {
    private static final long serialVersionUID = 1L;

    ASTBitwiseLeftShift(int id) {
        super(id);
    }

    public ASTBitwiseLeftShift() {
        super(25);
    }

    public ASTBitwiseLeftShift(Object[] nodes) {
        super(25);
        int len = nodes.length;
        for (int i = 0; i < len; ++i) {
            this.jjtAddChild(this.wrapChild(nodes[i]), i);
        }
        this.connectChildren();
    }

    public ASTBitwiseLeftShift(Collection<Object> nodes) {
        super(25);
        int len = nodes.size();
        Iterator<Object> it = nodes.iterator();
        for (int i = 0; i < len; ++i) {
            this.jjtAddChild(this.wrapChild(it.next()), i);
        }
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        int len = this.jjtGetNumChildren();
        if (len == 0) {
            return null;
        }
        Long result = null;
        for (int i = 0; i < len; ++i) {
            Long value = ConversionUtil.toLong(this.evaluateChild(i, o), Long.MIN_VALUE);
            if (value == Long.MIN_VALUE) {
                return null;
            }
            result = i == 0 ? value : result << (int)value.longValue();
        }
        return result;
    }

    @Override
    protected String getExpressionOperator(int index) {
        return "<<";
    }

    @Override
    public int getType() {
        return 43;
    }

    @Override
    protected String getEJBQLExpressionOperator(int index) {
        throw new UnsupportedOperationException("EJBQL 'bitwise not' is not supported");
    }

    @Override
    public Expression shallowCopy() {
        return new ASTBitwiseLeftShift(this.id);
    }

    @Override
    public void jjtClose() {
        super.jjtClose();
        this.flattenTree();
    }
}

