/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.ProcedureAction;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.translator.procedure.ProcedureTranslator;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;

public class SQLServerProcedureAction
extends ProcedureAction {
    public SQLServerProcedureAction(ProcedureQuery query, DataNode dataNode) {
        super(query, dataNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        ProcedureTranslator transl = this.createTranslator(connection);
        CallableStatement statement = (CallableStatement)transl.createStatement();
        try {
            boolean hasResultSet = statement.execute();
            Observer localObserver = new Observer(observer);
            while (true) {
                if (hasResultSet) {
                    ResultSet rs = statement.getResultSet();
                    try {
                        RowDescriptor descriptor = this.describeResultSet(rs, this.processedResultSets++);
                        this.readResultSet(rs, descriptor, this.query, localObserver);
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (SQLException ex) {}
                    }
                }
                int updateCount = statement.getUpdateCount();
                if (updateCount == -1) break;
                this.dataNode.getJdbcEventLogger().logUpdateCount(updateCount);
                localObserver.nextCount(this.query, updateCount);
                hasResultSet = statement.getMoreResults();
            }
            this.readProcedureOutParameters(statement, observer);
            localObserver.flushResults(this.query);
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException ex) {}
        }
    }

    class Observer
    implements OperationObserver {
        List<List<?>> results;
        List<Integer> counts;
        OperationObserver observer;

        Observer(OperationObserver observer) {
            this.observer = observer;
        }

        void flushResults(Query query) {
            if (this.results != null) {
                for (List list : this.results) {
                    this.observer.nextRows(query, list);
                }
                this.results = null;
            }
            if (this.counts != null) {
                for (Integer n : this.counts) {
                    this.observer.nextCount(query, n);
                }
                this.counts = null;
            }
        }

        @Override
        public void nextBatchCount(Query query, int[] resultCount) {
            this.observer.nextBatchCount(query, resultCount);
        }

        @Override
        public void nextCount(Query query, int resultCount) {
            if (this.counts == null) {
                this.counts = new ArrayList<Integer>();
            }
            this.counts.add(resultCount);
        }

        @Override
        public void nextRows(Query query, List<?> dataRows) {
            if (this.results == null) {
                this.results = new ArrayList();
            }
            this.results.add(dataRows);
        }

        public void nextRows(Query q, ResultIterator it) {
            this.observer.nextRows(q, it);
        }

        @Override
        public void nextGlobalException(Exception ex) {
            this.observer.nextGlobalException(ex);
        }

        public void nextGeneratedRows(Query query, ResultIterator keys, ObjectId idToUpdate) {
            this.observer.nextGeneratedRows(query, keys, idToUpdate);
        }

        @Override
        public void nextQueryException(Query query, Exception ex) {
            this.observer.nextQueryException(query, ex);
        }

        @Override
        public boolean isIteratedResult() {
            return this.observer.isIteratedResult();
        }
    }
}

