/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.sql.Driver;
import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.conn.DriverDataSource;
import org.apache.cayenne.conn.PoolDataSource;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLPoolingDataSourceFactory
implements DataSourceFactory {
    private static final Log logger = LogFactory.getLog(XMLPoolingDataSourceFactory.class);
    @Inject
    protected JdbcEventLogger jdbcEventLogger;
    @Inject
    private RuntimeProperties properties;
    @Inject
    private AdhocObjectFactory objectFactory;

    @Override
    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        DataSourceInfo dataSourceDescriptor = nodeDescriptor.getDataSourceDescriptor();
        if (dataSourceDescriptor == null) {
            String message = "Null dataSourceDescriptor for nodeDescriptor '" + nodeDescriptor.getName() + "'";
            logger.info((Object)message);
            throw new ConfigurationException(message, new Object[0]);
        }
        Driver driver = (Driver)this.objectFactory.newInstance(Driver.class, dataSourceDescriptor.getJdbcDriver());
        DriverDataSource driverDS = new DriverDataSource(driver, dataSourceDescriptor.getDataSourceUrl(), dataSourceDescriptor.getUserName(), dataSourceDescriptor.getPassword());
        driverDS.setLogger(this.jdbcEventLogger);
        PoolDataSource poolDS = new PoolDataSource(driverDS);
        try {
            return new PoolManager(poolDS, dataSourceDescriptor.getMinConnections(), dataSourceDescriptor.getMaxConnections(), dataSourceDescriptor.getUserName(), dataSourceDescriptor.getPassword(), this.properties.getLong("cayenne.jdbc.max_wait", 20000L));
        }
        catch (Exception e) {
            this.jdbcEventLogger.logConnectFailure(e);
            throw e;
        }
    }
}

