/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.FixedDataSourceFactory;
import org.apache.cayenne.configuration.server.FixedJNDIDataSourceFactory;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.configuration.server.SyntheticNodeDataDomainProvider;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.di.Module;

public class ServerRuntimeBuilder {
    static final String DEFAULT_NAME = "cayenne";
    private String name;
    private Collection<String> configs = new LinkedHashSet<String>();
    private List<Module> modules = new ArrayList<Module>();
    private DataSourceFactory dataSourceFactory;
    private String jdbcUrl;
    private String jdbcDriver;
    private String jdbcUser;
    private String jdbcPassword;
    private int jdbcMinConnections;
    private int jdbcMaxConnections;

    public ServerRuntimeBuilder() {
        this(null);
    }

    public ServerRuntimeBuilder(String name) {
        this.name = name;
    }

    public ServerRuntimeBuilder dataSource(DataSource dataSource) {
        this.dataSourceFactory = new FixedDataSourceFactory(dataSource);
        return this;
    }

    public ServerRuntimeBuilder jndiDataSource(String location) {
        this.dataSourceFactory = new FixedJNDIDataSourceFactory(location);
        return this;
    }

    public ServerRuntimeBuilder url(String url) {
        this.jdbcUrl = url;
        return this;
    }

    public ServerRuntimeBuilder jdbcDriver(String driver) {
        this.jdbcDriver = driver;
        return this;
    }

    public ServerRuntimeBuilder user(String user) {
        this.jdbcUser = user;
        return this;
    }

    public ServerRuntimeBuilder password(String password) {
        this.jdbcPassword = password;
        return this;
    }

    public ServerRuntimeBuilder minConnections(int minConnections) {
        this.jdbcMinConnections = minConnections;
        return this;
    }

    public ServerRuntimeBuilder maxConnections(int maxConnections) {
        this.jdbcMaxConnections = maxConnections;
        return this;
    }

    public ServerRuntimeBuilder addConfig(String configurationLocation) {
        this.configs.add(configurationLocation);
        return this;
    }

    public ServerRuntimeBuilder addConfigs(String ... configurationLocations) {
        if (configurationLocations != null) {
            this.configs.addAll(Arrays.asList(configurationLocations));
        }
        return this;
    }

    public ServerRuntimeBuilder addConfigs(Collection<String> configurationLocations) {
        this.configs.addAll(configurationLocations);
        return this;
    }

    public ServerRuntimeBuilder addModule(Module module) {
        this.modules.add(module);
        return this;
    }

    public ServerRuntimeBuilder addModules(Collection<Module> modules) {
        this.modules.addAll(modules);
        return this;
    }

    public ServerRuntime build() {
        this.buildModules();
        String[] configs = this.configs.toArray(new String[this.configs.size()]);
        Module[] modules = this.modules.toArray(new Module[this.modules.size()]);
        return new ServerRuntime(configs, modules);
    }

    private void buildModules() {
        String nameOverride = this.name;
        if (nameOverride == null && this.configs.size() != 1) {
            nameOverride = DEFAULT_NAME;
        }
        if (nameOverride != null) {
            final String finalNameOverride = nameOverride;
            this.prepend(new Module(){

                public void configure(Binder binder) {
                    binder.bindMap("cayenne.properties").put("cayenne.server.domain.name", (Object)finalNameOverride);
                }
            });
        }
        if (this.dataSourceFactory != null) {
            this.prepend(new Module(){

                public void configure(Binder binder) {
                    binder.bind(DataDomain.class).toProvider(SyntheticNodeDataDomainProvider.class);
                    binder.bind(DataSourceFactory.class).toInstance((Object)ServerRuntimeBuilder.this.dataSourceFactory);
                }
            });
        } else if (this.jdbcUrl != null && this.jdbcDriver != null) {
            this.prepend(new Module(){

                public void configure(Binder binder) {
                    binder.bind(DataDomain.class).toProvider(SyntheticNodeDataDomainProvider.class);
                    MapBuilder props = binder.bindMap("cayenne.properties").put("cayenne.jdbc.driver", (Object)ServerRuntimeBuilder.this.jdbcDriver).put("cayenne.jdbc.url", (Object)ServerRuntimeBuilder.this.jdbcUrl);
                    if (ServerRuntimeBuilder.this.jdbcUser != null) {
                        props.put("cayenne.jdbc.username", (Object)ServerRuntimeBuilder.this.jdbcUser);
                    }
                    if (ServerRuntimeBuilder.this.jdbcPassword != null) {
                        props.put("cayenne.jdbc.password", (Object)ServerRuntimeBuilder.this.jdbcPassword);
                    }
                    if (ServerRuntimeBuilder.this.jdbcMinConnections > 0) {
                        props.put("cayenne.jdbc.min_connections", (Object)Integer.toString(ServerRuntimeBuilder.this.jdbcMinConnections));
                    }
                    if (ServerRuntimeBuilder.this.jdbcMaxConnections > 0) {
                        props.put("cayenne.jdbc.max_connections", (Object)Integer.toString(ServerRuntimeBuilder.this.jdbcMaxConnections));
                    }
                }
            });
        }
    }

    private void prepend(Module module) {
        this.modules.add(0, module);
    }
}

