/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DefaultObjectMapRetainStrategy;
import org.apache.cayenne.access.ObjectMapRetainStrategy;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategy;
import org.apache.cayenne.access.dbsync.SkipSchemaUpdateStrategy;
import org.apache.cayenne.access.jdbc.SQLTemplateProcessor;
import org.apache.cayenne.access.jdbc.reader.DefaultRowReaderFactory;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.access.translator.batch.DefaultBatchTranslatorFactory;
import org.apache.cayenne.access.types.BigDecimalType;
import org.apache.cayenne.access.types.BigIntegerType;
import org.apache.cayenne.access.types.BooleanType;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.ByteType;
import org.apache.cayenne.access.types.CalendarType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.DateType;
import org.apache.cayenne.access.types.DoubleType;
import org.apache.cayenne.access.types.FloatType;
import org.apache.cayenne.access.types.IntegerType;
import org.apache.cayenne.access.types.LongType;
import org.apache.cayenne.access.types.ShortType;
import org.apache.cayenne.access.types.TimeType;
import org.apache.cayenne.access.types.TimestampType;
import org.apache.cayenne.access.types.UUIDType;
import org.apache.cayenne.access.types.UtilDateType;
import org.apache.cayenne.access.types.VoidType;
import org.apache.cayenne.ashwood.AshwoodEntitySorter;
import org.apache.cayenne.cache.MapQueryCacheProvider;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.DataChannelDescriptorLoader;
import org.apache.cayenne.configuration.DataChannelDescriptorMerger;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.DefaultConfigurationNameMapper;
import org.apache.cayenne.configuration.DefaultDataChannelDescriptorMerger;
import org.apache.cayenne.configuration.DefaultObjectStoreFactory;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.configuration.ObjectStoreFactory;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.configuration.XMLDataMapLoader;
import org.apache.cayenne.configuration.server.DataContextFactory;
import org.apache.cayenne.configuration.server.DataDomainProvider;
import org.apache.cayenne.configuration.server.DataNodeFactory;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.configuration.server.DefaultDataNodeFactory;
import org.apache.cayenne.configuration.server.DefaultDbAdapterFactory;
import org.apache.cayenne.configuration.server.DelegatingDataSourceFactory;
import org.apache.cayenne.configuration.server.DomainDataChannelProvider;
import org.apache.cayenne.dba.db2.DB2Sniffer;
import org.apache.cayenne.dba.derby.DerbySniffer;
import org.apache.cayenne.dba.firebird.FirebirdSniffer;
import org.apache.cayenne.dba.frontbase.FrontBaseSniffer;
import org.apache.cayenne.dba.h2.H2Sniffer;
import org.apache.cayenne.dba.hsqldb.HSQLDBSniffer;
import org.apache.cayenne.dba.ingres.IngresSniffer;
import org.apache.cayenne.dba.mysql.MySQLSniffer;
import org.apache.cayenne.dba.openbase.OpenBaseSniffer;
import org.apache.cayenne.dba.oracle.OracleSniffer;
import org.apache.cayenne.dba.postgres.PostgresSniffer;
import org.apache.cayenne.dba.sqlite.SQLiteSniffer;
import org.apache.cayenne.dba.sqlserver.SQLServerSniffer;
import org.apache.cayenne.dba.sybase.SybaseSniffer;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.spi.DefaultAdhocObjectFactory;
import org.apache.cayenne.di.spi.DefaultClassLoaderManager;
import org.apache.cayenne.event.DefaultEventManager;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.log.CommonsJdbcEventLogger;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.resource.ClassLoaderResourceLocator;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.cayenne.tx.DefaultTransactionFactory;
import org.apache.cayenne.tx.DefaultTransactionManager;
import org.apache.cayenne.tx.TransactionFactory;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.velocity.VelocitySQLTemplateProcessor;

public class ServerModule
implements Module {
    private static final int DEFAULT_MAX_ID_QUALIFIER_SIZE = 10000;
    protected String[] configurationLocations;

    public ServerModule(String ... configurationLocations) {
        if (configurationLocations == null) {
            configurationLocations = new String[]{};
        }
        this.configurationLocations = configurationLocations;
    }

    public void configure(Binder binder) {
        binder.bindMap("cayenne.properties").put("cayenne.server.max_id_qualifier_size", (Object)String.valueOf(10000));
        binder.bind(JdbcEventLogger.class).to(CommonsJdbcEventLogger.class);
        binder.bind(ClassLoaderManager.class).to(DefaultClassLoaderManager.class);
        binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
        binder.bind(FirebirdSniffer.class).to(FirebirdSniffer.class);
        binder.bind(OpenBaseSniffer.class).to(OpenBaseSniffer.class);
        binder.bind(FrontBaseSniffer.class).to(FrontBaseSniffer.class);
        binder.bind(IngresSniffer.class).to(IngresSniffer.class);
        binder.bind(SQLiteSniffer.class).to(SQLiteSniffer.class);
        binder.bind(DB2Sniffer.class).to(DB2Sniffer.class);
        binder.bind(H2Sniffer.class).to(H2Sniffer.class);
        binder.bind(HSQLDBSniffer.class).to(HSQLDBSniffer.class);
        binder.bind(SybaseSniffer.class).to(SybaseSniffer.class);
        binder.bind(DerbySniffer.class).to(DerbySniffer.class);
        binder.bind(SQLServerSniffer.class).to(SQLServerSniffer.class);
        binder.bind(OracleSniffer.class).to(OracleSniffer.class);
        binder.bind(PostgresSniffer.class).to(PostgresSniffer.class);
        binder.bind(MySQLSniffer.class).to(MySQLSniffer.class);
        binder.bindList("cayenne.server.adapter_detectors").add(FirebirdSniffer.class).add(OpenBaseSniffer.class).add(FrontBaseSniffer.class).add(IngresSniffer.class).add(SQLiteSniffer.class).add(DB2Sniffer.class).add(H2Sniffer.class).add(HSQLDBSniffer.class).add(SybaseSniffer.class).add(DerbySniffer.class).add(SQLServerSniffer.class).add(OracleSniffer.class).add(PostgresSniffer.class).add(MySQLSniffer.class);
        binder.bindList("cayenne.server.domain_filters");
        binder.bindList("cayenne.server.default_types").add((Object)new VoidType()).add((Object)new BigDecimalType()).add((Object)new BigIntegerType()).add((Object)new BooleanType()).add((Object)new ByteArrayType(false, true)).add((Object)new ByteType(false)).add((Object)new CharType(false, true)).add((Object)new DateType()).add((Object)new DoubleType()).add((Object)new FloatType()).add((Object)new IntegerType()).add((Object)new LongType()).add((Object)new ShortType(false)).add((Object)new TimeType()).add((Object)new TimestampType()).add((Object)new UtilDateType()).add(new CalendarType<GregorianCalendar>(GregorianCalendar.class)).add(new CalendarType<Calendar>(Calendar.class)).add((Object)new UUIDType());
        binder.bindList("cayenne.server.user_types");
        binder.bindList("cayenne.server.type_factories");
        ListBuilder locationsListBuilder = binder.bindList("cayenne.server.project_locations");
        for (String location : this.configurationLocations) {
            locationsListBuilder.add((Object)location);
        }
        binder.bind(ConfigurationNameMapper.class).to(DefaultConfigurationNameMapper.class);
        binder.bind(EventManager.class).to(DefaultEventManager.class);
        binder.bind(QueryCache.class).toProvider(MapQueryCacheProvider.class);
        binder.bind(DataDomain.class).toProvider(DataDomainProvider.class);
        binder.bind(DataNodeFactory.class).to(DefaultDataNodeFactory.class);
        binder.bind(DataChannel.class).toProvider(DomainDataChannelProvider.class);
        binder.bind(ObjectContextFactory.class).to(DataContextFactory.class);
        binder.bind(TransactionFactory.class).to(DefaultTransactionFactory.class);
        binder.bind(DataChannelDescriptorLoader.class).to(XMLDataChannelDescriptorLoader.class);
        binder.bind(DataChannelDescriptorMerger.class).to(DefaultDataChannelDescriptorMerger.class);
        binder.bind(DataMapLoader.class).to(XMLDataMapLoader.class);
        binder.bind(ResourceLocator.class).to(ClassLoaderResourceLocator.class);
        binder.bind(RuntimeProperties.class).to(DefaultRuntimeProperties.class);
        binder.bind(DataSourceFactory.class).to(DelegatingDataSourceFactory.class);
        binder.bind(SchemaUpdateStrategy.class).to(SkipSchemaUpdateStrategy.class);
        binder.bind(DbAdapterFactory.class).to(DefaultDbAdapterFactory.class);
        binder.bind(EntitySorter.class).to(AshwoodEntitySorter.class).withoutScope();
        binder.bind(BatchTranslatorFactory.class).to(DefaultBatchTranslatorFactory.class);
        binder.bind(ObjectMapRetainStrategy.class).to(DefaultObjectMapRetainStrategy.class);
        binder.bind(ObjectStoreFactory.class).to(DefaultObjectStoreFactory.class);
        binder.bind(TransactionManager.class).to(DefaultTransactionManager.class);
        binder.bind(RowReaderFactory.class).to(DefaultRowReaderFactory.class);
        binder.bind(SQLTemplateProcessor.class).to(VelocitySQLTemplateProcessor.class);
    }
}

