/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataChannelDescriptorLoader;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.PasswordEncoding;
import org.apache.cayenne.configuration.SAXNestedTagHandler;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLDataChannelDescriptorLoader
implements DataChannelDescriptorLoader {
    private static Log logger = LogFactory.getLog(XMLDataChannelDescriptorLoader.class);
    static final String DOMAIN_TAG = "domain";
    static final String MAP_TAG = "map";
    static final String NODE_TAG = "node";
    static final String PROPERTY_TAG = "property";
    static final String MAP_REF_TAG = "map-ref";
    static final String DATA_SOURCE_TAG = "data-source";
    @Inject
    protected DataMapLoader dataMapLoader;
    @Inject
    protected ConfigurationNameMapper nameMapper;
    @Inject
    protected AdhocObjectFactory objectFactory;

    @Deprecated
    private static String passwordFromURL(URL url) {
        InputStream inputStream = null;
        String password = null;
        try {
            inputStream = url.openStream();
            password = XMLDataChannelDescriptorLoader.passwordFromInputStream(inputStream);
        }
        catch (IOException exception) {
            logger.warn((Object)exception);
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static String passwordFromInputStream(InputStream inputStream) {
        BufferedReader bufferedReader = null;
        String password = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            password = bufferedReader.readLine();
        }
        catch (IOException exception) {
            logger.warn((Object)exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return password;
    }

    @Override
    public ConfigurationTree<DataChannelDescriptor> load(Resource configurationResource) throws ConfigurationException {
        if (configurationResource == null) {
            throw new NullPointerException("Null configurationResource");
        }
        URL configurationURL = configurationResource.getURL();
        logger.info((Object)("Loading XML configuration resource from " + configurationURL));
        DataChannelDescriptor descriptor = new DataChannelDescriptor();
        descriptor.setConfigurationSource(configurationResource);
        descriptor.setName(this.nameMapper.configurationNodeName(DataChannelDescriptor.class, configurationResource));
        InputStream in = null;
        try {
            in = configurationURL.openStream();
            XMLReader parser = Util.createXmlReader();
            DataChannelHandler rootHandler = new DataChannelHandler(descriptor, parser);
            parser.setContentHandler(rootHandler);
            parser.setErrorHandler(rootHandler);
            parser.parse(new InputSource(in));
        }
        catch (Exception e) {
            throw new ConfigurationException("Error loading configuration from %s", (Throwable)e, configurationURL);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioex) {
                logger.info((Object)("failure closing input stream for " + configurationURL + ", ignoring"), (Throwable)ioex);
            }
        }
        return new ConfigurationTree<DataChannelDescriptor>(descriptor, null);
    }

    class DataSourceChildrenHandler
    extends SAXNestedTagHandler {
        private DataSourceInfo dataSourceDescriptor;

        DataSourceChildrenHandler(XMLReader parser, DataNodeChildrenHandler parentHandler, DataSourceInfo dataSourceDescriptor) {
            super(parser, parentHandler);
            this.dataSourceDescriptor = dataSourceDescriptor;
        }

        @Override
        protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String name, Attributes attributes) {
            if (localName.equals("driver")) {
                String className = attributes.getValue("", "value");
                this.dataSourceDescriptor.setJdbcDriver(className);
            } else if (localName.equals("login")) {
                logger.info((Object)"loading user name and password.");
                String encoderClass = attributes.getValue("encoderClass");
                String encoderKey = attributes.getValue("encoderKey");
                if (encoderKey == null) {
                    encoderKey = attributes.getValue("encoderSalt");
                }
                String password = attributes.getValue("password");
                String passwordLocation = attributes.getValue("passwordLocation");
                String passwordSource = attributes.getValue("passwordSource");
                if (passwordSource == null) {
                    passwordSource = "model";
                }
                String username = attributes.getValue("userName");
                this.dataSourceDescriptor.setPasswordEncoderClass(encoderClass);
                this.dataSourceDescriptor.setPasswordEncoderKey(encoderKey);
                this.dataSourceDescriptor.setPasswordLocation(passwordLocation);
                this.dataSourceDescriptor.setPasswordSource(passwordSource);
                this.dataSourceDescriptor.setUserName(username);
                if (encoderKey != null) {
                    passwordSource = passwordSource.replaceAll("\\{\\}", encoderKey);
                }
                String encoderType = this.dataSourceDescriptor.getPasswordEncoderClass();
                PasswordEncoding passwordEncoder = null;
                if (encoderType != null) {
                    passwordEncoder = (PasswordEncoding)XMLDataChannelDescriptorLoader.this.objectFactory.newInstance(PasswordEncoding.class, encoderType);
                }
                if (passwordLocation != null) {
                    if (passwordLocation.equals("classpath")) {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        URL url = classLoader.getResource(username);
                        if (url != null) {
                            password = XMLDataChannelDescriptorLoader.passwordFromURL(url);
                        } else {
                            logger.error((Object)("Could not find resource in CLASSPATH: " + passwordSource));
                        }
                    } else if (passwordLocation.equals("url")) {
                        try {
                            password = XMLDataChannelDescriptorLoader.passwordFromURL(new URL(passwordSource));
                        }
                        catch (MalformedURLException exception) {
                            logger.warn((Object)exception);
                        }
                    } else if (passwordLocation.equals("executable") && passwordSource != null) {
                        try {
                            Process process = Runtime.getRuntime().exec(passwordSource);
                            password = XMLDataChannelDescriptorLoader.passwordFromInputStream(process.getInputStream());
                            process.waitFor();
                        }
                        catch (IOException exception) {
                            logger.warn((Object)exception);
                        }
                        catch (InterruptedException exception) {
                            logger.warn((Object)exception);
                        }
                    }
                }
                if (password != null && passwordEncoder != null) {
                    this.dataSourceDescriptor.setPassword(passwordEncoder.decodePassword(password, encoderKey));
                }
            } else if (localName.equals("url")) {
                this.dataSourceDescriptor.setDataSourceUrl(attributes.getValue("value"));
            } else if (localName.equals("connectionPool")) {
                String max;
                String min = attributes.getValue("min");
                if (min != null) {
                    try {
                        this.dataSourceDescriptor.setMinConnections(Integer.parseInt(min));
                    }
                    catch (NumberFormatException nfex) {
                        logger.info((Object)"Non-numeric 'min' attribute", (Throwable)nfex);
                        throw new ConfigurationException("Non-numeric 'min' attribute '%s'", (Throwable)nfex, min);
                    }
                }
                if ((max = attributes.getValue("max")) != null) {
                    try {
                        this.dataSourceDescriptor.setMaxConnections(Integer.parseInt(max));
                    }
                    catch (NumberFormatException nfex) {
                        logger.info((Object)"Non-numeric 'max' attribute", (Throwable)nfex);
                        throw new ConfigurationException("Non-numeric 'max' attribute '%s'", (Throwable)nfex, max);
                    }
                }
            }
            return super.createChildTagHandler(namespaceURI, localName, name, attributes);
        }
    }

    final class DataNodeChildrenHandler
    extends SAXNestedTagHandler {
        private DataNodeDescriptor nodeDescriptor;

        DataNodeChildrenHandler(XMLReader parser, SAXNestedTagHandler parentHandler, DataNodeDescriptor nodeDescriptor) {
            super(parser, parentHandler);
            this.nodeDescriptor = nodeDescriptor;
        }

        @Override
        protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String name, Attributes attributes) {
            if (localName.equals(XMLDataChannelDescriptorLoader.MAP_REF_TAG)) {
                String mapName = attributes.getValue("", "name");
                this.nodeDescriptor.getDataMapNames().add(mapName);
            } else if (localName.equals(XMLDataChannelDescriptorLoader.DATA_SOURCE_TAG)) {
                DataSourceInfo dataSourceDescriptor = new DataSourceInfo();
                this.nodeDescriptor.setDataSourceDescriptor(dataSourceDescriptor);
                return new DataSourceChildrenHandler(this.parser, this, dataSourceDescriptor);
            }
            return super.createChildTagHandler(namespaceURI, localName, name, attributes);
        }
    }

    final class DataChannelChildrenHandler
    extends SAXNestedTagHandler {
        private DataChannelDescriptor descriptor;

        DataChannelChildrenHandler(XMLReader parser, DataChannelHandler parentHandler) {
            super(parser, parentHandler);
            this.descriptor = parentHandler.descriptor;
        }

        @Override
        protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String name, Attributes attributes) {
            if (localName.equals(XMLDataChannelDescriptorLoader.PROPERTY_TAG)) {
                String key = attributes.getValue("", "name");
                String value = attributes.getValue("", "value");
                if (key != null && value != null) {
                    this.descriptor.getProperties().put(key, value);
                }
            } else if (localName.equals(XMLDataChannelDescriptorLoader.MAP_TAG)) {
                String dataMapName = attributes.getValue("", "name");
                Resource baseResource = this.descriptor.getConfigurationSource();
                String dataMapLocation = XMLDataChannelDescriptorLoader.this.nameMapper.configurationLocation(DataMap.class, dataMapName);
                Resource dataMapResource = baseResource.getRelativeResource(dataMapLocation);
                logger.info((Object)("Loading XML DataMap resource from " + dataMapResource.getURL()));
                DataMap dataMap = XMLDataChannelDescriptorLoader.this.dataMapLoader.load(dataMapResource);
                dataMap.setName(dataMapName);
                dataMap.setLocation(dataMapLocation);
                dataMap.setConfigurationSource(dataMapResource);
                dataMap.setDataChannelDescriptor(this.descriptor);
                this.descriptor.getDataMaps().add(dataMap);
            } else if (localName.equals(XMLDataChannelDescriptorLoader.NODE_TAG)) {
                String nodeName = attributes.getValue("", "name");
                if (nodeName == null) {
                    throw new ConfigurationException("Error: <node> without 'name'.", new Object[0]);
                }
                DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor();
                nodeDescriptor.setConfigurationSource(this.descriptor.getConfigurationSource());
                this.descriptor.getNodeDescriptors().add(nodeDescriptor);
                nodeDescriptor.setName(nodeName);
                nodeDescriptor.setAdapterType(attributes.getValue("", "adapter"));
                String parameters = attributes.getValue("", "parameters");
                nodeDescriptor.setParameters(parameters);
                String dataSourceFactory = attributes.getValue("", "factory");
                nodeDescriptor.setDataSourceFactoryType(dataSourceFactory);
                nodeDescriptor.setSchemaUpdateStrategyType(attributes.getValue("", "schema-update-strategy"));
                nodeDescriptor.setDataChannelDescriptor(this.descriptor);
                return new DataNodeChildrenHandler(this.parser, this, nodeDescriptor);
            }
            return super.createChildTagHandler(namespaceURI, localName, name, attributes);
        }
    }

    final class DataChannelHandler
    extends SAXNestedTagHandler {
        private DataChannelDescriptor descriptor;

        DataChannelHandler(DataChannelDescriptor dataChannelDescriptor, XMLReader parser) {
            super(parser, null);
            this.descriptor = dataChannelDescriptor;
        }

        @Override
        protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String name, Attributes attributes) {
            if (localName.equals(XMLDataChannelDescriptorLoader.DOMAIN_TAG)) {
                return new DataChannelChildrenHandler(this.parser, this);
            }
            logger.info((Object)this.unexpectedTagMessage(localName, XMLDataChannelDescriptorLoader.DOMAIN_TAG));
            return super.createChildTagHandler(namespaceURI, localName, name, attributes);
        }
    }
}

