/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import java.util.regex.Pattern;
import org.apache.cayenne.map.DbEntity;

public class DbPath
implements Comparable<DbPath> {
    public static final DbPath EMPTY = new DbPath();
    public static final String SEPARATOR = "/";
    public final String catalog;
    public final String schema;
    public final String tablePattern;
    private final String path;

    public DbPath() {
        this(null, null, null);
    }

    public DbPath(String catalog) {
        this(catalog, null, null);
    }

    public DbPath(String catalog, String schema) {
        this(catalog, schema, null);
    }

    public DbPath(String catalog, String schema, String tablePattern) {
        this.catalog = this.prepareValue(catalog);
        this.schema = this.prepareValue(schema);
        this.tablePattern = this.prepareValue(tablePattern);
        this.path = DbPath.join(this.catalog, this.schema, this.tablePattern);
    }

    private static String join(String first, String second) {
        if (second == null || second.equals("%")) {
            return first;
        }
        return DbPath.escapeNull(first) + SEPARATOR + second;
    }

    private static String join(String catalog, String schema, String table) {
        String join = DbPath.join(catalog, DbPath.join(schema, table));
        return DbPath.escapeNull(join);
    }

    private static String escapeNull(String join) {
        return join == null ? "%" : join;
    }

    private String prepareValue(String value) {
        return value == null ? null : value.trim();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbPath dbPath = (DbPath)o;
        return this.path.equals(dbPath.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }

    @Override
    public int compareTo(DbPath o) {
        return this.path.compareTo(o.path);
    }

    public boolean isCover(String catalog, String schema) {
        return this.isCover(catalog, schema, null);
    }

    public boolean isCover(String catalog, String schema, String table) {
        if (this.catalog == null && catalog == null) {
            return this.schemaCover(schema, table);
        }
        if (this.catalog == null) {
            return this.schemaCover(schema, table);
        }
        return this.catalog.equalsIgnoreCase(catalog) && this.schemaCover(schema, table);
    }

    private boolean schemaCover(String schema, String table) {
        if (this.schema == null && schema == null) {
            return this.tableCover(table);
        }
        if (this.schema == null) {
            return this.tableCover(table);
        }
        return this.schema.equalsIgnoreCase(schema) && this.tableCover(table);
    }

    private boolean tableCover(String table) {
        return this.tablePattern == null || table != null && Pattern.compile(this.tablePattern, 2).matcher(table).matches();
    }

    public boolean isCover(DbPath dbPath) {
        if (dbPath == null) {
            throw new IllegalArgumentException("dbPath can't be null");
        }
        return this.isCover(dbPath.catalog, dbPath.schema, dbPath.tablePattern);
    }

    public DbPath merge(DbPath path) {
        if (this.isCover(path)) {
            return this;
        }
        if (path.isCover(this)) {
            return path;
        }
        return null;
    }

    public static DbPath build(DbEntity entity) {
        return new DbPath(entity.getCatalog(), entity.getSchema(), entity.getName());
    }
}

