/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.sql.SQLException;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.inheritance_people.Department;
import org.apache.cayenne.testdo.inheritance_people.Employee;
import org.apache.cayenne.testdo.inheritance_people.Manager;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.PeopleProjectCase;
import org.apache.cayenne.util.DeepMergeOperation;
import org.junit.Assert;
import org.junit.Test;

public class DeepMergeOperationInheritanceIT
extends PeopleProjectCase {
    @Inject
    private DataContext context;
    @Inject
    private DataContext context1;
    @Inject
    protected DataChannelInterceptor queryInterceptor;

    @Test
    public void testDeepMergeExistingSubclass() {
        final Department d1 = this.context.newObject(Department.class);
        d1.setName("D1");
        this.context.commitChanges();
        Employee e1 = this.context.newObject(Employee.class);
        e1.setName("E1");
        e1.setPersonType("EE");
        d1.addToEmployees(e1);
        Manager e2 = this.context.newObject(Manager.class);
        e2.setName("E2");
        e2.setPersonType("EM");
        d1.addToEmployees(e2);
        this.context.commitChanges();
        d1.getEmployees().size();
        this.context1.performQuery(new SelectQuery<Employee>(Employee.class));
        final DeepMergeOperation op = new DeepMergeOperation(this.context1);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Department d2 = op.merge(d1);
                Assert.assertNotNull((Object)d2);
                Assert.assertEquals((long)3L, (long)d2.getPersistenceState());
                for (Employee ex : d2.getEmployees()) {
                    if ("E2".equals(ex.getName())) {
                        Assert.assertTrue((boolean)(ex instanceof Manager));
                        continue;
                    }
                    Assert.assertFalse((boolean)(ex instanceof Manager));
                }
            }
        });
    }

    @Test
    public void testDeepMergeNonExistentSubclass() throws SQLException {
        final Department d1 = this.context.newObject(Department.class);
        d1.setName("D1");
        this.context.commitChanges();
        Employee e1 = this.context.newObject(Employee.class);
        e1.setName("E1");
        e1.setPersonType("EE");
        d1.addToEmployees(e1);
        Manager e2 = this.context.newObject(Manager.class);
        e2.setName("E2");
        e2.setPersonType("EM");
        d1.addToEmployees(e2);
        this.context.commitChanges();
        d1.getEmployees().size();
        final DeepMergeOperation op = new DeepMergeOperation(this.context1);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Department d2 = op.merge(d1);
                Assert.assertNotNull((Object)d2);
                Assert.assertEquals((long)3L, (long)d2.getPersistenceState());
                for (Employee ex : d2.getEmployees()) {
                    if ("E2".equals(ex.getName())) {
                        Assert.assertTrue((boolean)(ex instanceof Manager));
                        continue;
                    }
                    Assert.assertFalse((boolean)(ex instanceof Manager));
                }
            }
        });
    }
}

