/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.di.server;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.dbsync.SkipSchemaUpdateStrategy;
import org.apache.cayenne.access.jdbc.SQLTemplateProcessor;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataNodeFactory;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;

public class ServerCaseDataNodeFactory
implements DataNodeFactory {
    @Inject
    private JdbcEventLogger jdbcEventLogger;
    @Inject
    protected RowReaderFactory rowReaderFactory;
    @Inject
    protected BatchTranslatorFactory batchTranslatorFactory;
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;
    @Inject
    private DbAdapter adapter;
    @Inject
    protected SQLTemplateProcessor sqlTemplateProcessor;

    @Override
    public DataNode createDataNode(DataNodeDescriptor nodeDescriptor) throws Exception {
        DataNode dataNode = new DataNode(nodeDescriptor.getName());
        dataNode.setJdbcEventLogger(this.jdbcEventLogger);
        dataNode.setRowReaderFactory(this.rowReaderFactory);
        dataNode.setBatchTranslatorFactory(this.batchTranslatorFactory);
        dataNode.setDataSource(this.dataSourceFactory.getDataSource(nodeDescriptor.getName()));
        dataNode.setAdapter(this.adapter);
        dataNode.setSchemaUpdateStrategy(new SkipSchemaUpdateStrategy());
        dataNode.setSqlTemplateProcessor(this.sqlTemplateProcessor);
        return dataNode;
    }
}

