/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.ParameterizedQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryMetadataWrapper;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.query.SelectQueryMetadata;
import org.apache.cayenne.query.SelectQueryPrefetchRouterAction;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class SelectQuery<T>
extends AbstractQuery
implements ParameterizedQuery,
XMLSerializable,
Select<T> {
    private static final long serialVersionUID = 5486418811888197559L;
    public static final String DISTINCT_PROPERTY = "cayenne.SelectQuery.distinct";
    public static final boolean DISTINCT_DEFAULT = false;
    protected Expression qualifier;
    protected List<Ordering> orderings;
    protected boolean distinct;
    SelectQueryMetadata metaData = new SelectQueryMetadata();

    public static <T> SelectQuery<T> query(Class<T> rootClass) {
        return new SelectQuery<T>(rootClass);
    }

    public static <T> SelectQuery<T> query(Class<T> rootClass, Expression qualifier) {
        return new SelectQuery<T>(rootClass, qualifier);
    }

    public static <T> SelectQuery<T> query(Class<T> rootClass, Expression qualifier, List<? extends Ordering> orderings) {
        return new SelectQuery<T>(rootClass, qualifier, orderings);
    }

    public static SelectQuery<DataRow> dataRowQuery(Class<?> rootClass) {
        SelectQuery<DataRow> query = new SelectQuery<DataRow>();
        query.setRoot(rootClass);
        query.metaData.setFetchingDataRows(true);
        return query;
    }

    public static SelectQuery<DataRow> dataRowQuery(Class<?> rootClass, Expression qualifier) {
        SelectQuery<DataRow> query = SelectQuery.dataRowQuery(rootClass);
        query.setQualifier(qualifier);
        return query;
    }

    public static SelectQuery<DataRow> dataRowQuery(Class<?> rootClass, Expression qualifier, List<Ordering> orderings) {
        SelectQuery<DataRow> query = SelectQuery.dataRowQuery(rootClass, qualifier);
        query.addOrderings(orderings);
        return query;
    }

    public SelectQuery() {
    }

    public SelectQuery(ObjEntity root) {
        this(root, null);
    }

    public SelectQuery(ObjEntity root, Expression qualifier) {
        this(root, qualifier, null);
    }

    public SelectQuery(ObjEntity root, Expression qualifier, List<? extends Ordering> orderings) {
        this();
        super.init(root, qualifier);
        this.addOrderings(orderings);
    }

    public SelectQuery(Class<T> rootClass) {
        this(rootClass, null);
    }

    public SelectQuery(Class<T> rootClass, Expression qualifier) {
        this(rootClass, qualifier, null);
    }

    public SelectQuery(Class<T> rootClass, Expression qualifier, List<? extends Ordering> orderings) {
        this.init(rootClass, qualifier);
        this.addOrderings(orderings);
    }

    public SelectQuery(DbEntity root) {
        this(root, null);
    }

    public SelectQuery(DbEntity root, Expression qualifier) {
        this(root, qualifier, null);
    }

    public SelectQuery(DbEntity root, Expression qualifier, List<? extends Ordering> orderings) {
        this();
        super.init(root, qualifier);
        this.addOrderings(orderings);
    }

    public SelectQuery(String objEntityName) {
        this(objEntityName, null);
    }

    public SelectQuery(String objEntityName, Expression qualifier) {
        this(objEntityName, qualifier, null);
    }

    public SelectQuery(String objEntityName, Expression qualifier, List<? extends Ordering> orderings) {
        this.init(objEntityName, qualifier);
        this.addOrderings(orderings);
    }

    private void init(Object root, Expression qualifier) {
        this.setRoot(root);
        this.setQualifier(qualifier);
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        this.metaData.resolve(this.root, resolver, this);
        if (this.root instanceof DbEntity) {
            QueryMetadataWrapper wrapper = new QueryMetadataWrapper(this.metaData);
            wrapper.override("cayenne.GenericSelectQuery.fetchingDataRows", Boolean.TRUE);
            return wrapper;
        }
        return this.metaData;
    }

    @Override
    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        super.route(router, resolver, substitutedQuery);
        if (this.metaData.getPageSize() <= 0) {
            this.routePrefetches(router, resolver);
        }
    }

    void routePrefetches(QueryRouter router, EntityResolver resolver) {
        new SelectQueryPrefetchRouterAction().route(this, router, resolver);
    }

    @Override
    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return visitor.objectSelectAction(this);
    }

    public void initWithProperties(Map<String, ?> properties) {
        Object distinct;
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        this.distinct = (distinct = properties.get(DISTINCT_PROPERTY)) != null ? "true".equalsIgnoreCase(distinct.toString()) : false;
        this.metaData.initWithProperties(properties);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<query name=\"");
        encoder.print(this.getName());
        encoder.print("\" factory=\"");
        encoder.print("org.apache.cayenne.map.SelectQueryBuilder");
        String rootString = null;
        String rootType = null;
        if (this.root instanceof String) {
            rootType = "obj-entity";
            rootString = this.root.toString();
        } else if (this.root instanceof ObjEntity) {
            rootType = "obj-entity";
            rootString = ((ObjEntity)this.root).getName();
        } else if (this.root instanceof DbEntity) {
            rootType = "db-entity";
            rootString = ((DbEntity)this.root).getName();
        } else if (this.root instanceof Procedure) {
            rootType = "procedure";
            rootString = ((Procedure)this.root).getName();
        } else if (this.root instanceof Class) {
            rootType = "java-class";
            rootString = ((Class)this.root).getName();
        }
        if (rootType != null) {
            encoder.print("\" root=\"");
            encoder.print(rootType);
            encoder.print("\" root-name=\"");
            encoder.print(rootString);
        }
        encoder.println("\">");
        encoder.indent(1);
        if (this.distinct) {
            encoder.printProperty(DISTINCT_PROPERTY, this.distinct);
        }
        this.metaData.encodeAsXML(encoder);
        if (this.qualifier != null) {
            encoder.print("<qualifier>");
            this.qualifier.encodeAsXML(encoder);
            encoder.println("</qualifier>");
        }
        if (this.orderings != null && !this.orderings.isEmpty()) {
            for (Ordering ordering : this.orderings) {
                ordering.encodeAsXML(encoder);
            }
        }
        encoder.indent(-1);
        encoder.println("</query>");
    }

    public SelectQuery<T> queryWithParameters(Map<String, ?> parameters) {
        return this.queryWithParameters(parameters, true);
    }

    public SelectQuery<T> queryWithParameters(Map<String, ?> parameters, boolean pruneMissing) {
        SelectQuery<T> query = new SelectQuery<T>();
        query.setDistinct(this.distinct);
        query.metaData.copyFromInfo(this.metaData);
        query.setRoot(this.root);
        if (this.orderings != null) {
            query.addOrderings(this.orderings);
        }
        if (this.qualifier != null) {
            query.setQualifier(this.qualifier.params(parameters, pruneMissing));
        }
        return query;
    }

    @Override
    public SelectQuery<T> createQuery(Map<String, ?> parameters) {
        return this.queryWithParameters(parameters);
    }

    public void addOrdering(Ordering ordering) {
        this.nonNullOrderings().add(ordering);
    }

    public void addOrderings(Collection<? extends Ordering> orderings) {
        if (orderings != null) {
            this.nonNullOrderings().addAll(orderings);
        }
    }

    public void addOrdering(String sortPathSpec, SortOrder order) {
        this.addOrdering(new Ordering(sortPathSpec, order));
    }

    public void removeOrdering(Ordering ordering) {
        if (this.orderings != null) {
            this.orderings.remove(ordering);
        }
    }

    public List<Ordering> getOrderings() {
        return this.orderings != null ? this.orderings : Collections.emptyList();
    }

    public void clearOrderings() {
        this.orderings = null;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void aliasPathSplits(String path, String ... aliases) {
        this.metaData.addPathSplitAliases(path, aliases);
    }

    public PrefetchTreeNode getPrefetchTree() {
        return this.metaData.getPrefetchTree();
    }

    public void setPrefetchTree(PrefetchTreeNode prefetchTree) {
        this.metaData.setPrefetchTree(prefetchTree);
    }

    public void addPrefetch(PrefetchTreeNode prefetchElement) {
        this.metaData.mergePrefetch(prefetchElement);
    }

    public PrefetchTreeNode addPrefetch(String prefetchPath) {
        return this.metaData.addPrefetch(prefetchPath, 0);
    }

    public void clearPrefetches() {
        this.metaData.clearPrefetches();
    }

    public void removePrefetch(String prefetchPath) {
        this.metaData.removePrefetch(prefetchPath);
    }

    public boolean isFetchingDataRows() {
        return this.root instanceof DbEntity || this.metaData.isFetchingDataRows();
    }

    public void setFetchingDataRows(boolean flag) {
        this.metaData.setFetchingDataRows(flag);
    }

    public QueryCacheStrategy getCacheStrategy() {
        return this.metaData.getCacheStrategy();
    }

    public void setCacheStrategy(QueryCacheStrategy strategy) {
        this.metaData.setCacheStrategy(strategy);
    }

    public String[] getCacheGroups() {
        return this.metaData.getCacheGroups();
    }

    public void setCacheGroups(String ... cacheGroups) {
        this.metaData.setCacheGroups(cacheGroups);
    }

    public void useLocalCache(String ... cacheGroups) {
        this.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        this.setCacheGroups(cacheGroups);
    }

    public void useSharedCache(String ... cacheGroups) {
        this.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        this.setCacheGroups(cacheGroups);
    }

    public int getFetchOffset() {
        return this.metaData.getFetchOffset();
    }

    public int getFetchLimit() {
        return this.metaData.getFetchLimit();
    }

    public void setFetchLimit(int fetchLimit) {
        this.metaData.setFetchLimit(fetchLimit);
    }

    public void setFetchOffset(int fetchOffset) {
        this.metaData.setFetchOffset(fetchOffset);
    }

    public int getPageSize() {
        return this.metaData.getPageSize();
    }

    public void setPageSize(int pageSize) {
        this.metaData.setPageSize(pageSize);
    }

    List<Ordering> nonNullOrderings() {
        if (this.orderings == null) {
            this.orderings = new ArrayList<Ordering>(3);
        }
        return this.orderings;
    }

    public void setStatementFetchSize(int size) {
        this.metaData.setStatementFetchSize(size);
    }

    public int getStatementFetchSize() {
        return this.metaData.getStatementFetchSize();
    }

    public void setQualifier(Expression qualifier) {
        this.qualifier = qualifier;
    }

    public Expression getQualifier() {
        return this.qualifier;
    }

    public void andQualifier(Expression e) {
        this.qualifier = this.qualifier != null ? this.qualifier.andExp(e) : e;
    }

    public void orQualifier(Expression e) {
        this.qualifier = this.qualifier != null ? this.qualifier.orExp(e) : e;
    }
}

