/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.QueryChain;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class QueryChainIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testSelectQuery() {
        QueryChain chain = new QueryChain();
        chain.addQuery(new SelectQuery<Artist>(Artist.class));
        chain.addQuery(new SelectQuery<Artist>(Artist.class));
        QueryMetadata md = chain.getMetaData(this.runtime.getDataDomain().getEntityResolver());
        Assert.assertNotNull((Object)md);
        Assert.assertTrue((boolean)md.isFetchingDataRows());
        Assert.assertNull((Object)md.getObjEntity());
    }

    @Test
    public void testSelectQueryDataRows() {
        QueryChain chain = new QueryChain();
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
        q1.setFetchingDataRows(true);
        chain.addQuery(q1);
        SelectQuery<Artist> q2 = new SelectQuery<Artist>(Artist.class);
        q2.setFetchingDataRows(true);
        chain.addQuery(q2);
        QueryMetadata md = chain.getMetaData(this.runtime.getDataDomain().getEntityResolver());
        Assert.assertNotNull((Object)md);
        Assert.assertTrue((boolean)md.isFetchingDataRows());
        Assert.assertNull((Object)md.getObjEntity());
    }
}

