/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.merge.MergeCase;
import org.junit.Assert;
import org.junit.Test;

public class MergerFactoryIT
extends MergeCase {
    @Inject
    private DataContext context;

    @Test
    public void testAddAndDropColumnToDb() throws Exception {
        DbEntity dbEntity = this.map.getDbEntity("PAINTING");
        Assert.assertNotNull((Object)dbEntity);
        DbAttribute column = new DbAttribute("NEWCOL1", 12, dbEntity);
        column.setMandatory(false);
        column.setMaxLength(10);
        dbEntity.addAttribute(column);
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
        dbEntity.removeAttribute(column.getName());
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
    }

    @Test
    public void testChangeVarcharSizeToDb() throws Exception {
        DbEntity dbEntity = this.map.getDbEntity("PAINTING");
        Assert.assertNotNull((Object)dbEntity);
        DbAttribute column = new DbAttribute("NEWCOL2", 12, dbEntity);
        column.setMandatory(false);
        column.setMaxLength(10);
        dbEntity.addAttribute(column);
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
        column.setMaxLength(20);
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
        dbEntity.removeAttribute(column.getName());
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
    }

    @Test
    public void testMultipleTokensToDb() throws Exception {
        DbEntity dbEntity = this.map.getDbEntity("PAINTING");
        Assert.assertNotNull((Object)dbEntity);
        DbAttribute column1 = new DbAttribute("NEWCOL3", 12, dbEntity);
        column1.setMandatory(false);
        column1.setMaxLength(10);
        dbEntity.addAttribute(column1);
        DbAttribute column2 = new DbAttribute("NEWCOL4", 12, dbEntity);
        column2.setMandatory(false);
        column2.setMaxLength(10);
        dbEntity.addAttribute(column2);
        this.assertTokensAndExecute(2, 0);
        this.assertTokensAndExecute(0, 0);
        column1.setMaxLength(20);
        column2.setMaxLength(30);
        this.assertTokensAndExecute(2, 0);
        this.assertTokensAndExecute(0, 0);
        dbEntity.removeAttribute(column1.getName());
        dbEntity.removeAttribute(column2.getName());
        this.assertTokensAndExecute(2, 0);
        this.assertTokensAndExecute(0, 0);
    }

    @Test
    public void testAddTableToDb() throws Exception {
        this.dropTableIfPresent("NEW_TABLE");
        this.assertTokensAndExecute(0, 0);
        DbEntity dbEntity = new DbEntity("NEW_TABLE");
        DbAttribute column1 = new DbAttribute("ID", 4, dbEntity);
        column1.setMandatory(true);
        column1.setPrimaryKey(true);
        dbEntity.addAttribute(column1);
        DbAttribute column2 = new DbAttribute("NAME", 12, dbEntity);
        column2.setMaxLength(10);
        column2.setMandatory(false);
        dbEntity.addAttribute(column2);
        this.map.addDbEntity(dbEntity);
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
        ObjEntity objEntity = new ObjEntity("NewTable");
        objEntity.setDbEntity(dbEntity);
        ObjAttribute oatr1 = new ObjAttribute("name");
        oatr1.setDbAttributePath(column2.getName());
        oatr1.setType("java.lang.String");
        objEntity.addAttribute(oatr1);
        this.map.addObjEntity(objEntity);
        for (int i = 0; i < 5; ++i) {
            CayenneDataObject dao = (CayenneDataObject)this.context.newObject(objEntity.getName());
            dao.writeProperty(oatr1.getName(), "test " + i);
        }
        this.context.commitChanges();
        this.map.removeObjEntity(objEntity.getName(), true);
        this.map.removeDbEntity(dbEntity.getName(), true);
        this.resolver.refreshMappingCache();
        Assert.assertNull((Object)this.map.getObjEntity(objEntity.getName()));
        Assert.assertNull((Object)this.map.getDbEntity(dbEntity.getName()));
        Assert.assertFalse((boolean)this.map.getDbEntities().contains(dbEntity));
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
    }

    @Test
    public void testAddForeignKeyWithTable() throws Exception {
        this.dropTableIfPresent("NEW_TABLE");
        this.assertTokensAndExecute(0, 0);
        DbEntity dbEntity = new DbEntity("NEW_TABLE");
        MergerFactoryIT.attr(dbEntity, "ID", 4, true, true);
        MergerFactoryIT.attr(dbEntity, "NAME", 12, false, false).setMaxLength(10);
        MergerFactoryIT.attr(dbEntity, "ARTIST_ID", -5, false, false);
        this.map.addDbEntity(dbEntity);
        DbEntity artistDbEntity = this.map.getDbEntity("ARTIST");
        Assert.assertNotNull((Object)artistDbEntity);
        DbRelationship r1 = new DbRelationship("toArtistR1");
        r1.setSourceEntity(dbEntity);
        r1.setTargetEntityName(artistDbEntity);
        r1.setToMany(false);
        r1.addJoin(new DbJoin(r1, "ARTIST_ID", "ARTIST_ID"));
        dbEntity.addRelationship(r1);
        DbRelationship r2 = new DbRelationship("toNewTableR2");
        r2.setSourceEntity(artistDbEntity);
        r2.setTargetEntityName(dbEntity);
        r2.setToMany(true);
        r2.addJoin(new DbJoin(r2, "ARTIST_ID", "ARTIST_ID"));
        artistDbEntity.addRelationship(r2);
        this.assertTokensAndExecute(2, 0);
        this.assertTokensAndExecute(0, 0);
        dbEntity.removeRelationship(r1.getName());
        artistDbEntity.removeRelationship(r2.getName());
        this.resolver.refreshMappingCache();
        this.assertTokensAndExecute(1, 1);
        this.assertTokensAndExecute(0, 0);
        this.map.removeDbEntity(dbEntity.getName(), true);
        this.resolver.refreshMappingCache();
        Assert.assertNull((Object)this.map.getDbEntity(dbEntity.getName()));
        Assert.assertFalse((boolean)this.map.getDbEntities().contains(dbEntity));
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
    }

    @Test
    public void testAddForeignKeyAfterTable() throws Exception {
        this.dropTableIfPresent("NEW_TABLE");
        this.assertTokensAndExecute(0, 0);
        DbEntity dbEntity = new DbEntity("NEW_TABLE");
        MergerFactoryIT.attr(dbEntity, "ID", 4, true, true);
        MergerFactoryIT.attr(dbEntity, "NAME", 12, false, false).setMaxLength(10);
        MergerFactoryIT.attr(dbEntity, "ARTIST_ID", -5, false, false);
        this.map.addDbEntity(dbEntity);
        DbEntity artistDbEntity = this.map.getDbEntity("ARTIST");
        Assert.assertNotNull((Object)artistDbEntity);
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
        DbRelationship r1 = new DbRelationship("toArtistR1");
        r1.setSourceEntity(dbEntity);
        r1.setTargetEntityName(artistDbEntity);
        r1.setToMany(false);
        r1.addJoin(new DbJoin(r1, "ARTIST_ID", "ARTIST_ID"));
        dbEntity.addRelationship(r1);
        DbRelationship r2 = new DbRelationship("toNewTableR2");
        r2.setSourceEntity(artistDbEntity);
        r2.setTargetEntityName(dbEntity);
        r2.setToMany(true);
        r2.addJoin(new DbJoin(r2, "ARTIST_ID", "ARTIST_ID"));
        artistDbEntity.addRelationship(r2);
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
        dbEntity.removeRelationship(r1.getName());
        artistDbEntity.removeRelationship(r2.getName());
        this.resolver.refreshMappingCache();
        this.assertTokensAndExecute(1, 1);
        this.assertTokensAndExecute(0, 0);
        this.map.removeDbEntity(dbEntity.getName(), true);
        this.resolver.refreshMappingCache();
        Assert.assertNull((Object)this.map.getDbEntity(dbEntity.getName()));
        Assert.assertFalse((boolean)this.map.getDbEntities().contains(dbEntity));
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
    }

    private static DbAttribute attr(DbEntity dbEntity, String name, int type, boolean mandatory, boolean primaryKey) {
        DbAttribute column1 = new DbAttribute(name, type, dbEntity);
        column1.setMandatory(mandatory);
        column1.setPrimaryKey(primaryKey);
        dbEntity.addAttribute(column1);
        return column1;
    }
}

